/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.metrics;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.onebusaway.aws.monitoring.impl.metrics.MetricsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.metrics.TransitimeMetrics;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class TransitimeMetricsImpl
extends MetricsTemplate
implements TransitimeMetrics,
ApplicationListener<ContextRefreshedEvent> {
    private String transitime_url = "";

    private void reloadConfig() {
        this.transitime_url = this._configurationService.getConfigurationValueAsString("monitoring.transitimeUrl", "http://gtfsrt.dev.wmata.obaweb.org:8080/api/v1/key/4b248c1b/command/");
    }

    public void publishGtfsRtMetric() {
        double metric = 1.0;
        try {
            JsonObject agencyList = this.getJsonObject(this.transitime_url + "agencies?format=json");
            JsonArray agencies = agencyList.get("agency").getAsJsonArray();
            for (JsonElement agencyElement : agencies) {
                JsonObject agency = agencyElement.getAsJsonObject();
                if (agency == null || !agency.get("name").getAsString().equalsIgnoreCase("WMATA")) continue;
                metric = 0.0;
                break;
            }
            this.publishMetric(MetricName.TransitimeApiErrorResponse, StandardUnit.Count, Double.valueOf(metric));
        }
        catch (Exception e) {
            _log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.reloadConfig();
    }
}

