/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.tasks.alarms;

import org.onebusaway.aws.monitoring.service.alarms.AdminServerAlarms;
import org.onebusaway.aws.monitoring.service.alarms.RealtimeAlarms;
import org.onebusaway.aws.monitoring.service.alarms.WebappAlarms;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class GenerateAlarmsTask
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger _log = LoggerFactory.getLogger(GenerateAlarmsTask.class);
    @Autowired
    ConfigurationService _configService;
    @Autowired
    WebappAlarms webappAlarms;
    @Autowired
    AdminServerAlarms adminServerAlarms;
    @Autowired
    RealtimeAlarms realtimeAlarms;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this._configService != null && Boolean.parseBoolean(this._configService.getConfigurationValueAsString("alarm.createAlarms", "false"))) {
            this.webappAlarms.createDesktopUiValidAlarm();
            this.webappAlarms.createNextBusApiAlarm();
            this.webappAlarms.createSmsApiAlarm();
            this.webappAlarms.createStopMonitoringAlarm();
            this.adminServerAlarms.createCurrentBundleCountAlarm();
            this.adminServerAlarms.createFirstValidBundleFilesCountAlarm();
            this.realtimeAlarms.createRealtimeInvalidLatLonPctAlarm();
            this.realtimeAlarms.createRealtimeLocationsInvalidAlarm();
            this.realtimeAlarms.createRealtimeLocationsTotalAlarm();
            this.realtimeAlarms.createRealtimeLocationsTotalPctAlarm();
            this.realtimeAlarms.createRealtimeStopsMatchedAlarm();
            this.realtimeAlarms.createRealtimeStopsMatchedPctAlarm();
            this.realtimeAlarms.createRealtimeStopsUnmatchedAlarm();
            this.realtimeAlarms.createRealtimeStopsUnmatchedPctAlarm();
            this.realtimeAlarms.createRealtimeTripsMatchedAlarm();
            this.realtimeAlarms.createRealtimeTripsMatchedAvgAlarm();
            this.realtimeAlarms.createRealtimeTripsTotalAlarm();
            this.realtimeAlarms.createRealtimeTripsUnmatchedAlarm();
            this.realtimeAlarms.createRealtimeTripTotalPctAlarm();
            this.realtimeAlarms.createScheduleRealtimeDeltaAlarm();
            this.realtimeAlarms.createRealtimeBusesInServiceAlarm();
            _log.info("Created alarms");
        }
    }
}

