/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.tasks.metrics;

import org.onebusaway.aws.monitoring.service.metrics.AdminServerMetrics;
import org.onebusaway.aws.monitoring.service.metrics.RealtimeMetrics;
import org.onebusaway.aws.monitoring.service.metrics.ScheduleMetrics;
import org.onebusaway.aws.monitoring.service.metrics.TransitimeMetrics;
import org.onebusaway.aws.monitoring.service.metrics.WebappMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.annotation.Scheduled;

public class PublishMetricsTask
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    WebappMetrics webappMetrics;
    @Autowired
    AdminServerMetrics adminServerMetrics;
    @Autowired
    TransitimeMetrics transitimeMetrics;
    @Autowired
    ScheduleMetrics scheduledMetrics;
    @Autowired
    RealtimeMetrics realtimeMetrics;
    private static final Logger _log = LoggerFactory.getLogger(PublishMetricsTask.class);
    private boolean initialized = false;

    @Scheduled(fixedRate=60000L)
    public void publishEveryMinute() {
        if (this.initialized) {
            this.webappMetrics.publishVehicleMonitoringMetrics();
            this.webappMetrics.publishStopMonitoringMetrics();
            this.webappMetrics.publishSmsApiMetrics();
            this.webappMetrics.publishNextBusApiMetrics();
            this.webappMetrics.publishDesktopUiMetrics();
            this.adminServerMetrics.publishBundleCountMetrics();
            this.transitimeMetrics.publishGtfsRtMetric();
            this.scheduledMetrics.publishAgencyTotalMetric();
            this.scheduledMetrics.publishExpiryDateDeltaMetric();
            this.scheduledMetrics.publishTotalTripsMetric();
            this.realtimeMetrics.publishLocationMetrics();
            this.realtimeMetrics.publishStopMetrics();
            this.realtimeMetrics.publishTripMetrics();
            this.realtimeMetrics.publishDeltaMetrics();
            _log.info("Published Metrics");
        } else {
            _log.info("Waiting to initialize PublishMetricsTask");
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.initialized = true;
    }
}

