/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api;

import cern.colt.Arrays;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.watchdog.api.LongTermAveragesResource;
import org.onebusaway.watchdog.api.MetricResource;
import org.onebusaway.watchdog.model.MetricConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LongTermAveragesResource
extends MetricResource {
    protected static final Logger _log = LoggerFactory.getLogger(LongTermAveragesResource.class);
    private int _refreshInterval = 30;
    private ScheduledExecutorService _scheduledExecutorService;
    private ScheduledFuture<?> _refreshTask;
    private List<String> agencyIds;
    protected static int matchedTripsAvg = 0;
    protected static int unmatchedTripsAvg = 0;
    protected static int ROLLING_AVERAGE_COUNT = 10;
    protected static int[] recentMatchedTrips = new int[ROLLING_AVERAGE_COUNT];
    protected static int[] recentUnmatchedTrips = new int[ROLLING_AVERAGE_COUNT];
    protected static int currentTripCt = 0;
    protected static int earliestTripIdx = 0;
    private static Map<String, int[]> matchedTripAveragesByAgency = new HashMap();
    private static Map<String, int[]> unmatchedTripAveragesByAgency = new HashMap();
    private static Map<String, int[]> busesInServicePctByAgency = new HashMap();
    private static Map<String, int[]> stopsMatchedByAgency = new HashMap();
    private static Map<String, int[]> stopsUnmatchedByAgency = new HashMap();
    private static Map<String, int[]> tripScheduleRealtimeDiffByAgency = new HashMap();
    private static Map<String, int[]> tripTotalsByAgency = new HashMap();
    private static Map<String, int[]> locationInvalidLatLonByAgency = new HashMap();
    private static Map<String, int[]> locationTotalsByAgency = new HashMap();

    public void setRefreshInterval(int refreshInterval) {
        this._refreshInterval = refreshInterval;
    }

    protected int getMatchedTripsAvg() {
        return matchedTripsAvg;
    }

    protected int getAvgByAgency(String metricType, String agencyId) {
        int[] metricTotals = null;
        if (metricType.equals("matched-trips-average")) {
            metricTotals = (int[])matchedTripAveragesByAgency.get(agencyId);
            _log.debug("matched by agency, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else if (metricType.equals("unmatched-trips-average")) {
            metricTotals = (int[])unmatchedTripAveragesByAgency.get(agencyId);
            _log.debug("unmatched by agency, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else if (metricType.equals("buses-in-service-pct")) {
            metricTotals = (int[])busesInServicePctByAgency.get(agencyId);
            _log.debug("buses in service pct, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else if (metricType.equals("matched-stops")) {
            metricTotals = (int[])stopsMatchedByAgency.get(agencyId);
            _log.debug("stops matched, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else if (metricType.equals("unmatched-stops")) {
            metricTotals = (int[])stopsUnmatchedByAgency.get(agencyId);
            _log.debug("stops unmatched, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else if (metricType.equals("trip-total")) {
            metricTotals = (int[])tripTotalsByAgency.get(agencyId);
            _log.debug("trip-total, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else if (metricType.equals("trip-schedule-realtime-diff")) {
            metricTotals = (int[])tripScheduleRealtimeDiffByAgency.get(agencyId);
            _log.debug("trip-schedule-realtime-diff, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else if (metricType.equals("location-total")) {
            metricTotals = (int[])locationTotalsByAgency.get(agencyId);
            _log.debug("location-total, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else if (metricType.equals("location-invalid-lat-lon")) {
            metricTotals = (int[])locationInvalidLatLonByAgency.get(agencyId);
            _log.debug("location-invalid-lat-lon, agency: " + agencyId + ", totals: " + (Serializable)(metricTotals != null ? Arrays.toString((int[])metricTotals) : Integer.valueOf(0)));
        } else {
            return 0;
        }
        return metricTotals != null ? this.calcAverage(metricTotals) : 0;
    }

    protected int getUnmatchedTripsAvg() {
        return unmatchedTripsAvg;
    }

    @PostConstruct
    public void start() {
        try {
            this.agencyIds = this.getAgencyList();
            for (String agencyId : this.agencyIds) {
                matchedTripAveragesByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
                unmatchedTripAveragesByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
                busesInServicePctByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
                stopsMatchedByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
                stopsUnmatchedByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
                tripTotalsByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
                tripScheduleRealtimeDiffByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
                locationTotalsByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
                locationInvalidLatLonByAgency.put(agencyId, new int[ROLLING_AVERAGE_COUNT]);
            }
            if (this._refreshInterval > 0) {
                int i = 0;
                while (this._refreshTask == null && !this._scheduledExecutorService.isShutdown()) {
                    ++i;
                    _log.info("scheduling long term average with refresh = " + this._refreshInterval);
                    try {
                        this._refreshTask = this._scheduledExecutorService.scheduleAtFixedRate((Runnable)new RefreshTask(this), this._refreshInterval, this._refreshInterval, TimeUnit.SECONDS);
                    }
                    catch (RejectedExecutionException ree) {
                        _log.error("executor rejected execution of {}, trying again, try {}", (Object)this.getClass().getName(), (Object)i);
                        Thread.sleep(6000 * i);
                    }
                }
            }
        }
        catch (Throwable t) {
            _log.error("exception initalizing: ", (Object)t, (Object)t);
        }
    }

    @PreDestroy
    public void stop() {
        if (this._refreshTask != null) {
            this._refreshTask.cancel(true);
            this._refreshTask = null;
        }
        if (this._scheduledExecutorService != null) {
            this._scheduledExecutorService.shutdown();
        }
    }

    @Autowired
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this._scheduledExecutorService = scheduledExecutorService;
    }

    @Autowired
    public void setMetricConfiguration(MetricConfiguration mc) {
        this._configuration = mc;
    }

    protected List<MonitoredDataSource> getDataSources() {
        return this._configuration.getDataSources();
    }

    protected void updateLongTermMatchedTrips(int currentMatchedTrips, int idx) {
        LongTermAveragesResource.recentMatchedTrips[idx] = currentMatchedTrips;
        int sum = 0;
        for (int i : recentMatchedTrips) {
            sum += i;
        }
        matchedTripsAvg = currentTripCt != 0 ? sum / currentTripCt : 0;
    }

    protected void updateLongTermUnmatchedTrips(int currentUnmatchedTrips, int idx) {
        LongTermAveragesResource.recentUnmatchedTrips[idx] = currentUnmatchedTrips;
        int sum = 0;
        for (int i : recentUnmatchedTrips) {
            sum += i;
        }
        unmatchedTripsAvg = currentTripCt != 0 ? sum / currentTripCt : 0;
    }

    public void refresh() throws IOException {
        int n;
        int totalMatchedTripCt = 0;
        int totalUnmatchedTripCt = 0;
        boolean busesInServicePct = false;
        HashMap<String, Integer> matchedByAgency = new HashMap<String, Integer>();
        HashMap<String, Integer> unmatchedByAgency = new HashMap<String, Integer>();
        HashMap<String, Integer> busesInServiceByAgency = new HashMap<String, Integer>();
        HashMap<String, Integer> currentTripTotalsByAgency = new HashMap<String, Integer>();
        HashMap<String, Integer> matchedStopsByAgency = new HashMap<String, Integer>();
        HashMap<String, Integer> unmatchedStopsByAgency = new HashMap<String, Integer>();
        HashMap<String, Integer> tripsDiffsByAgency = new HashMap<String, Integer>();
        HashMap<String, Integer> locsByAgency = new HashMap<String, Integer>();
        HashMap<String, Integer> locsInvalidByAgency = new HashMap<String, Integer>();
        for (String agencyId : this.agencyIds) {
            Integer matched = (Integer)matchedByAgency.get(agencyId);
            if (matched == null) {
                matched = 0;
            }
            matched = matched + this.getValidRealtimeTripIds(agencyId, null).size();
            totalMatchedTripCt += matched.intValue();
            matchedByAgency.put(agencyId, matched);
        }
        for (String agencyId : this.agencyIds) {
            Integer unmatched = (Integer)unmatchedByAgency.get(agencyId);
            if (unmatched == null) {
                unmatched = 0;
            }
            unmatched = unmatched + this.getUnmatchedTripIdCt(agencyId, null);
            totalUnmatchedTripCt += unmatched.intValue();
            unmatchedByAgency.put(agencyId, unmatched);
        }
        for (String agencyId : this.agencyIds) {
            double scheduledTrips = this.getScheduledTrips(agencyId);
            double validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, null).size();
            int percent = (int)Math.round(scheduledTrips != 0.0 ? validRealtimeTrips / scheduledTrips * 100.0 : 2.147483647E9);
            busesInServiceByAgency.put(agencyId, percent);
        }
        for (String agencyId : this.agencyIds) {
            int matched = this.getMatchedStopCt(agencyId, null);
            matchedStopsByAgency.put(agencyId, matched);
        }
        for (String agencyId : this.agencyIds) {
            int unmatched = this.getUnmatchedStopCt(agencyId, null);
            unmatchedStopsByAgency.put(agencyId, unmatched);
        }
        for (String agencyId : this.agencyIds) {
            int total = this.getTotalRecordCount(agencyId, null);
            currentTripTotalsByAgency.put(agencyId, total);
        }
        for (String agencyId : this.agencyIds) {
            int scheduledTrips = this.getScheduledTrips(agencyId);
            int validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, null).size();
            int diff = scheduledTrips - validRealtimeTrips;
            tripsDiffsByAgency.put(agencyId, diff);
        }
        for (String agencyId : this.agencyIds) {
            int total = this.getLocationTotal(agencyId, null);
            locsByAgency.put(agencyId, total);
        }
        for (String agencyId : this.agencyIds) {
            int total = this.getInvalidLocation(agencyId, null);
            locsInvalidByAgency.put(agencyId, total);
        }
        if (currentTripCt < ROLLING_AVERAGE_COUNT) {
            int n2 = currentTripCt;
            n = n2;
            currentTripCt = n2 + 1;
        } else {
            int n3 = earliestTripIdx;
            n = n3;
            earliestTripIdx = n3 + 1;
        }
        int idx = n;
        this.updateTotals(matchedTripAveragesByAgency, matchedByAgency, idx);
        this.updateTotals(unmatchedTripAveragesByAgency, unmatchedByAgency, idx);
        this.updateTotals(busesInServicePctByAgency, busesInServiceByAgency, idx);
        this.updateTotals(tripTotalsByAgency, currentTripTotalsByAgency, idx);
        this.updateTotals(stopsMatchedByAgency, matchedStopsByAgency, idx);
        this.updateTotals(stopsUnmatchedByAgency, unmatchedStopsByAgency, idx);
        this.updateTotals(tripScheduleRealtimeDiffByAgency, tripsDiffsByAgency, idx);
        this.updateTotals(locationTotalsByAgency, locsByAgency, idx);
        this.updateTotals(locationInvalidLatLonByAgency, locsInvalidByAgency, idx);
        this.updateLongTermMatchedTrips(totalMatchedTripCt, idx);
        this.updateLongTermUnmatchedTrips(totalUnmatchedTripCt, idx);
        earliestTripIdx %= ROLLING_AVERAGE_COUNT;
        _log.debug("Averages updated: matched = " + matchedTripsAvg + ", unmatched = " + unmatchedTripsAvg);
    }

    private void updateTotals(Map<String, int[]> totalsByAgency, Map<String, Integer> latestTotalByAgency, int idx) {
        for (String agencyId : totalsByAgency.keySet()) {
            int[] totalsForThisAgency = totalsByAgency.get(agencyId);
            Integer latestTotal = latestTotalByAgency.get(agencyId);
            if (latestTotal == null) {
                latestTotal = 0;
            }
            totalsForThisAgency[idx] = latestTotal;
            totalsByAgency.put(agencyId, totalsForThisAgency);
        }
    }

    private List<String> getAgencyList() {
        try {
            List agencyBeans = this.getTDS().getAgenciesWithCoverage();
            this.agencyIds = new ArrayList();
            for (AgencyWithCoverageBean agency : agencyBeans) {
                this.agencyIds.add(agency.getAgency().getId());
            }
        }
        catch (Exception e) {
            _log.error("getAgencyList broke", (Throwable)e);
        }
        return this.agencyIds;
    }

    private int calcAverage(int[] metricTotals) {
        int sum = 0;
        for (int i : metricTotals) {
            sum += i;
        }
        return currentTripCt != 0 ? sum / currentTripCt : 0;
    }
}

