/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api.realtime;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.util.SystemTime;
import org.onebusaway.watchdog.api.MetricResource;

@Path(value="/metric/realtime/agency")
public class AgencyResource
extends MetricResource {
    @Path(value="{agencyId}/last-update-delta")
    @GET
    @Produces(value={"application/json"})
    public Response getLastUpdateDelta(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            long lastUpdate = 0L;
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("last-update-delta", "no configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    lastUpdate += result.getLastUpdate();
                }
            }
            return Response.ok((Object)this.ok("last-update-delta", (Object)((SystemTime.currentTimeMillis() - lastUpdate) / 1000L))).build();
        }
        catch (Exception e) {
            _log.error("getLastUpdateDelta broke", (Throwable)e);
            return Response.ok((Object)this.error("last-update-delta", e)).build();
        }
    }
}

