/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api.realtime;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.VehicleStatusBean;
import org.onebusaway.watchdog.api.MetricResource;
import org.onebusaway.watchdog.api.realtime.AssignmentConflictResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/metric/realtime/conflicts")
public class AssignmentConflictResource
extends MetricResource {
    protected static final Logger _log = LoggerFactory.getLogger(AssignmentConflictResource.class);
    private ScheduledExecutorService _scheduledExecutorService;
    private ScheduledFuture<?> _refreshTask;
    private int _refreshInterval = 30;
    private Map<String, VehicleHistory> vehicleHistoryMap = new HashMap();
    private Map<String, ActiveVehicles> vehiclesByTrip = new HashMap();
    private Map<String, VehicleHistory> tripConflicts = new HashMap();
    private Map<String, VehicleHistory> blockConflicts = new HashMap();
    private Map<String, ActiveVehicles> vehicleConflicts = new HashMap();

    @Autowired
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this._scheduledExecutorService = scheduledExecutorService;
    }

    @Path(value="trip/list")
    @GET
    @Produces(value={"application/json"})
    public Response getAllTripConflicts() {
        HashMap trips = new HashMap(this.tripConflicts);
        return Response.ok((Object)this.ok("trip-conflicts-list", (Object)this.printVehicleHistory(trips))).build();
    }

    @Path(value="block/list")
    @GET
    @Produces(value={"application/json"})
    public Response getAllBlockConflicts() {
        HashMap blocks = new HashMap(this.blockConflicts);
        return Response.ok((Object)this.ok("block-conflicts-list", (Object)this.printVehicleHistory(blocks))).build();
    }

    @Path(value="vehicle/list")
    @GET
    @Produces(value={"application/json"})
    public Response getAllVehicleConflicts() {
        HashMap vehiclesMap = new HashMap(this.vehicleConflicts);
        return Response.ok((Object)this.ok("vehicle-conflicts-list", (Object)this.printActiveVehicle(vehiclesMap))).build();
    }

    public synchronized void refresh() {
        long now = System.currentTimeMillis();
        for (AgencyWithCoverageBean ab : this.getTDS().getAgenciesWithCoverage()) {
            ListBean allVehiclesForAgency = this.getTDS().getAllVehiclesForAgency(ab.getAgency().getId(), now);
            for (VehicleStatusBean vsb : allVehiclesForAgency.getList()) {
                if (vsb.getTrip() == null) continue;
                this.addVehicle(vsb.getVehicleId(), vsb.getTrip().getId(), vsb.getTrip().getBlockId());
            }
        }
        this.tripConflicts.clear();
        this.blockConflicts.clear();
        for (String vehicleId : this.vehicleHistoryMap.keySet()) {
            VehicleHistory vh = (VehicleHistory)this.vehicleHistoryMap.get(vehicleId);
            if (vh.hasTripConflict()) {
                _log.debug("tripConflict " + vh);
                this.tripConflicts.put(vehicleId, vh);
            }
            if (!vh.hasBlockConflict()) continue;
            _log.debug("blockConflict " + vh);
            this.blockConflicts.put(vehicleId, vh);
        }
        this.vehicleConflicts.clear();
        int vcount = 0;
        for (String tripId : this.vehiclesByTrip.keySet()) {
            ActiveVehicles av = (ActiveVehicles)this.vehiclesByTrip.get(tripId);
            if (!av.hasConflict()) continue;
            ++vcount;
            _log.debug("vehicle conflict " + av + " for trip " + tripId);
            this.vehicleConflicts.put(tripId, av);
        }
        if (vcount > 0) {
            _log.debug(vcount + " conflicts this run");
        }
    }

    private void addVehicle(String vehicleId, String tripId, String blockId) {
        if (this.vehicleHistoryMap.containsKey(vehicleId)) {
            ((VehicleHistory)this.vehicleHistoryMap.get(vehicleId)).add(vehicleId, tripId, blockId);
        } else {
            VehicleHistory vh = new VehicleHistory(vehicleId, tripId, blockId);
            this.vehicleHistoryMap.put(vehicleId, vh);
        }
        if (this.vehiclesByTrip.containsKey(tripId)) {
            ((ActiveVehicles)this.vehiclesByTrip.get(tripId)).add(vehicleId);
        } else {
            ActiveVehicles av = new ActiveVehicles(vehicleId);
            this.vehiclesByTrip.put(tripId, av);
        }
    }

    private String printVehicleHistory(Map<String, VehicleHistory> map) {
        StringBuffer sb = new StringBuffer();
        sb.append("map = {");
        if (map == null) {
            return sb.toString();
        }
        int i = 0;
        for (String key : map.keySet()) {
            if (i > 0) {
                sb.append(",");
            }
            ++i;
            VehicleHistory vh = map.get(key);
            sb.append(key).append('=').append(vh.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    private String printActiveVehicle(Map<String, ActiveVehicles> map) {
        StringBuffer sb = new StringBuffer();
        sb.append("map = {");
        if (map == null) {
            return sb.toString();
        }
        int i = 0;
        for (String key : map.keySet()) {
            if (i > 0) {
                sb.append(",");
            }
            ++i;
            ActiveVehicles av = map.get(key);
            sb.append(key).append('=').append(av.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    @PostConstruct
    public void start() {
        int i = 0;
        while (this._refreshTask == null && !this._scheduledExecutorService.isShutdown()) {
            ++i;
            try {
                this._refreshTask = this._scheduledExecutorService.scheduleAtFixedRate((Runnable)new RefreshTask(this), 1L, this._refreshInterval, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException ree) {
                _log.error("executor rejected execution of {}, trying again, try {}", (Object)this.getClass().getName(), (Object)i);
                try {
                    Thread.sleep(5000 * i);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    @PreDestroy
    public void stop() {
        if (this._refreshTask != null) {
            this._refreshTask.cancel(true);
            this._refreshTask = null;
        }
        if (this._scheduledExecutorService != null) {
            this._scheduledExecutorService.shutdown();
        }
    }
}

