/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api.realtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.watchdog.api.MetricResource;

@Path(value="/metric/realtime/location")
public class LocationResource
extends MetricResource {
    @Path(value="{agencyId}/total")
    @GET
    @Produces(value={"application/json"})
    public Response getTotalLatLonCount(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            ArrayList totalLatLons = new ArrayList();
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("total-lat-lon-count", "no configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    totalLatLons.addAll(result.getAllCoordinates());
                }
            }
            return Response.ok((Object)this.ok("total-lat-lon-count", (Object)totalLatLons.size())).build();
        }
        catch (Exception e) {
            _log.error("getTotalLatLonCount broke", (Throwable)e);
            return Response.ok((Object)this.error("total-lat-lon-count", e)).build();
        }
    }

    @Path(value="{agencyId}/invalid")
    @GET
    @Produces(value={"application/json"})
    public Response getInvalidLatLonCount(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            ArrayList invalidLatLons = new ArrayList();
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("invalid-lat-lon-count", "no configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    invalidLatLons.addAll(this.findInvalidLatLon(agencyId, result.getAllCoordinates()));
                }
            }
            return Response.ok((Object)this.ok("invalid-lat-lon-count", (Object)invalidLatLons.size())).build();
        }
        catch (Exception e) {
            _log.error("getInvalidLatLonCount broke", (Throwable)e);
            return Response.ok((Object)this.error("invalid-lat-lon-count", e)).build();
        }
    }

    @Path(value="{agencyId}/invalid-lat-lons")
    @GET
    @Produces(value={"application/json"})
    public Response getInvalidLatLons(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            ArrayList invalidLatLons = new ArrayList();
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("invalid-lat-lons", "no configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    invalidLatLons.addAll(this.findInvalidLatLon(agencyId, result.getAllCoordinates()));
                }
            }
            return Response.ok((Object)this.ok("invalid-lat-lons", invalidLatLons)).build();
        }
        catch (Exception e) {
            _log.error("getInvalidLatLons broke", (Throwable)e);
            return Response.ok((Object)this.error("invalid-lat-lons", e)).build();
        }
    }

    private Collection<CoordinatePoint> findInvalidLatLon(String agencyId, Set<CoordinatePoint> coordinatePoints) {
        ArrayList<CoordinatePoint> invalid = new ArrayList<CoordinatePoint>();
        List bounds = (List)this.getTDS().getAgencyIdsWithCoverageArea().get(agencyId);
        if (bounds == null || bounds.isEmpty()) {
            _log.warn("no bounds configured for agency " + agencyId);
            for (CoordinatePoint pt : coordinatePoints) {
                invalid.add(pt);
            }
            return invalid;
        }
        for (CoordinateBounds bound : bounds) {
            boolean found = false;
            for (CoordinatePoint pt : coordinatePoints) {
                if (bound.contains(pt)) {
                    found = true;
                }
                if (found) continue;
                invalid.add(pt);
            }
        }
        _log.debug("agency " + agencyId + " had " + invalid.size() + " invalid out of " + coordinatePoints.size());
        return invalid;
    }
}

