/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.cloudwatch.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Date;
import java.util.List;
import org.onebusaway.aws.cloudwatch.service.CloudwatchService;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class CloudwatchServiceImpl
implements CloudwatchService,
ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    ConfigurationService _configurationService;
    AmazonCloudWatchClient cloudWatch;
    String endPoint = "monitoring.us-east-1.amazonaws.com";
    String environmentName = "dev";
    protected static final Logger _log = LoggerFactory.getLogger(CloudwatchServiceImpl.class);

    public void setup() {
        String accessKey = this._configurationService.getConfigurationValueAsString("aws.accessKey", "");
        String secretKey = this._configurationService.getConfigurationValueAsString("aws.secretKey", "");
        this.endPoint = this._configurationService.getConfigurationValueAsString("aws.endPoint", "monitoring.us-east-1.amazonaws.com");
        this.environmentName = this._configurationService.getConfigurationValueAsString("oba.env", "dev");
        AmazonCloudWatchClient cloudWatch = new AmazonCloudWatchClient((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        cloudWatch.setEndpoint(this.endPoint);
        this.cloudWatch = cloudWatch;
    }

    public void publishMetric(String metricName, StandardUnit unit, Double metricValue) {
        if (this.cloudWatch == null) {
            return;
        }
        MetricDatum datum = new MetricDatum().withMetricName(metricName).withTimestamp(new Date()).withValue(metricValue).withUnit(unit);
        PutMetricDataRequest putMetricDataRequest = new PutMetricDataRequest().withNamespace(this.environmentName).withMetricData(new MetricDatum[]{datum});
        this.cloudWatch.putMetricData(putMetricDataRequest);
        _log.debug("published metric : " + putMetricDataRequest.toString());
    }

    public void publishMetrics(List<MetricDatum> data) {
        if (this.cloudWatch == null) {
            return;
        }
        PutMetricDataRequest putMetricDataRequest = new PutMetricDataRequest().withNamespace(this.environmentName).withMetricData(data);
        this.cloudWatch.putMetricData(putMetricDataRequest);
        _log.debug("published metrics : " + putMetricDataRequest.toString());
    }

    public void publishAlarm(PutMetricAlarmRequest putMetricAlarmRequest) {
        this.cloudWatch.putMetricAlarm(putMetricAlarmRequest);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.setup();
    }
}

