/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.aws.monitoring.service.alarms.AdminServerAlarms;
import org.onebusaway.aws.monitoring.service.alarms.DatabaseAlarms;
import org.onebusaway.aws.monitoring.service.alarms.GtfsRtAlarms;
import org.onebusaway.aws.monitoring.service.alarms.RealtimeAlarms;
import org.onebusaway.aws.monitoring.service.alarms.WebappAlarms;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.onebusaway.watchdog.api.MetricResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/monitoring/alarms")
public class AlarmResource
extends MetricResource {
    private static final Logger _log = LoggerFactory.getLogger(AlarmResource.class);
    @Autowired
    WebappAlarms webappAlarms;
    @Autowired
    AdminServerAlarms adminServerAlarms;
    @Autowired
    RealtimeAlarms realtimeAlarms;
    @Autowired
    DatabaseAlarms databaseAlarms;
    @Autowired
    GtfsRtAlarms gtfsRtAlarms;
    @Autowired
    ConfigurationService _configurationService;

    @Path(value="create")
    @GET
    @Produces(value={"application/json"})
    public Response createAlarms() {
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("starting\n");
        try {
            this.webappAlarms.createDesktopUiValidAlarm();
            this.webappAlarms.createNextBusApiAlarm();
            this.webappAlarms.createSmsApiAlarm();
            this.webappAlarms.createStopMonitoringAlarm();
            logMsg.append("webappAlarms created\n");
            this.adminServerAlarms.createCurrentBundleCountAlarm();
            this.adminServerAlarms.createFirstValidBundleFilesCountAlarm();
            logMsg.append("adminServerAlarms created\n");
            this.gtfsRtAlarms.createMessagesDelayedAlarm();
            this.gtfsRtAlarms.createMessagesDeletedAlarm();
            this.gtfsRtAlarms.createMessagesReceivedAlarm();
            this.gtfsRtAlarms.createMessagesSentAlarm();
            this.gtfsRtAlarms.createMessagesSizeAlarm();
            logMsg.append("gtfsRtAlarms created\n");
            if (this.getDbInstances() != null) {
                for (String dbInstance : this.getDbInstances()) {
                    this.databaseAlarms.createRdsHighConnectionsAlarm(dbInstance);
                    this.databaseAlarms.createRdsHighCPUAlarm(dbInstance);
                    this.databaseAlarms.createRdsLowStorageAlarm(dbInstance);
                    this.databaseAlarms.createRdsReadLatencyAlarm(dbInstance);
                    this.databaseAlarms.createRdsWriteLatencyAlarm(dbInstance);
                    logMsg.append("Db " + dbInstance + " alarms created\n");
                }
            } else {
                logMsg.append("no db isntances defined!\n");
            }
            logMsg.append("Alarms created successfully\n");
            _log.info(logMsg.toString());
            return Response.ok((Object)logMsg.toString()).build();
        }
        catch (Exception e) {
            _log.error("Error creating alarms");
            return Response.ok((Object)"Error Creating Alarms").build();
        }
    }

    private List<String> getDbInstances() {
        String dbInstances = this._configurationService.getConfigurationValueAsString("alarm.dbInstances", "");
        if (StringUtils.isNotBlank((String)dbInstances)) {
            return Arrays.asList(dbInstances.split("\\s*,\\s*"));
        }
        return new ArrayList<String>(0);
    }
}

