/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.alarms;

import com.amazonaws.services.cloudwatch.model.ComparisonOperator;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.Statistic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.onebusaway.aws.cloudwatch.service.CloudwatchService;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public abstract class AlarmsTemplate
implements ApplicationListener<ContextRefreshedEvent> {
    private static final String ALARM = "Alarm";
    private static final String DEFAULT_ENV = "dev";
    private static final String CRITICAL_ACTION = "criticalAction";
    private static final String NON_CRITICAL_ACTION = "nonCriticalAction";
    private static final String AWS_RDS_DIMENSION = "DBInstanceIdentifier";
    private static final String AWS_RDS_NAMESPACE = "AWS/RDS";
    private static final String AWS_SQS_DIMENSION = "QueueName";
    private static final String AWS_SQS_NAMESPACE = "AWS/SQS";
    private static final String SQS_PREFIX = "Sqs";
    private String env = "";
    private String sqsQueue = "";
    private Map<String, String> actions = new HashMap();
    @Autowired
    CloudwatchService _cloudWatchService;
    @Autowired
    ConfigurationService _configService;

    public String getEnv() {
        return this.env;
    }

    public String getSqsQueue() {
        return this.sqsQueue;
    }

    public Map<String, String> getActions() {
        return this.actions;
    }

    public List<String> getCriticalAction() {
        ArrayList<String> action = new ArrayList<String>(1);
        action.add((String)this.actions.get(CRITICAL_ACTION));
        return action;
    }

    public List<String> getNonCriticalAction() {
        ArrayList<String> action = new ArrayList<String>(1);
        action.add((String)this.actions.get(NON_CRITICAL_ACTION));
        return action;
    }

    protected PutMetricAlarmRequest getMetricAlarmRequest(MetricName metricName) {
        return new PutMetricAlarmRequest().withActionsEnabled(Boolean.valueOf(true)).withMetricName(metricName.toString()).withAlarmName(this.getAlarmName(metricName.toString())).withPeriod(Integer.valueOf(60)).withEvaluationPeriods(Integer.valueOf(3)).withStatistic(Statistic.Average).withComparisonOperator(ComparisonOperator.GreaterThanOrEqualToThreshold).withNamespace(this.getEnv());
    }

    protected PutMetricAlarmRequest getRDSMetricAlarmRequest(MetricName metricName, String alarmName, String dbInstance) {
        return new PutMetricAlarmRequest().withActionsEnabled(Boolean.valueOf(true)).withMetricName(metricName.toString()).withAlarmName(this.getAlarmName(dbInstance + alarmName)).withPeriod(Integer.valueOf(60)).withEvaluationPeriods(Integer.valueOf(3)).withStatistic(Statistic.Average).withComparisonOperator(ComparisonOperator.GreaterThanOrEqualToThreshold).withNamespace(AWS_RDS_NAMESPACE).withDimensions(new Dimension[]{new Dimension().withName(AWS_RDS_DIMENSION).withValue(dbInstance)});
    }

    protected PutMetricAlarmRequest getSQSMetricAlarmRequest(MetricName metricName, String sqsQueue) {
        return new PutMetricAlarmRequest().withActionsEnabled(Boolean.valueOf(true)).withMetricName(metricName.toString()).withAlarmName(this.getAlarmName(SQS_PREFIX + metricName.toString())).withPeriod(Integer.valueOf(60)).withEvaluationPeriods(Integer.valueOf(3)).withUnit(StandardUnit.Count).withStatistic(Statistic.Average).withComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold).withNamespace(AWS_SQS_NAMESPACE).withDimensions(new Dimension[]{new Dimension().withName(AWS_SQS_DIMENSION).withValue(sqsQueue)});
    }

    protected String getAlarmName(String metricName) {
        return metricName + ALARM + WordUtils.capitalize((String)this.getEnv());
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this._configService == null) {
            this.actions.put(CRITICAL_ACTION, "");
            this.actions.put(NON_CRITICAL_ACTION, "");
        } else {
            this.env = this._configService.getConfigurationValueAsString("oba.env", DEFAULT_ENV);
            this.sqsQueue = this._configService.getConfigurationValueAsString("alarm.sqsQueue", DEFAULT_ENV);
            this.actions.put(CRITICAL_ACTION, this._configService.getConfigurationValueAsString("alarm.criticalSns", ""));
            this.actions.put(NON_CRITICAL_ACTION, this._configService.getConfigurationValueAsString("alarm.nonCriticalSns", ""));
        }
    }
}

