/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.alarms;

import com.amazonaws.services.cloudwatch.model.ComparisonOperator;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Collection;
import org.onebusaway.aws.monitoring.impl.alarms.AlarmsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.alarms.DatabaseAlarms;
import org.springframework.stereotype.Component;

@Component
public class DatabaseAlarmsImpl
extends AlarmsTemplate
implements DatabaseAlarms {
    public void createRdsHighConnectionsAlarm(String dbInstance) {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getRDSMetricAlarmRequest(MetricName.DatabaseConnections, "RdsHighConnections", dbInstance);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.dbHighConnections", Double.valueOf(400.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRdsLowStorageAlarm(String dbInstance) {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getRDSMetricAlarmRequest(MetricName.FreeStorageSpace, "RdsLowStorageSpace", dbInstance);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.dbFreeStorageSpace", Double.valueOf(3.0E9)));
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanThreshold);
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRdsReadLatencyAlarm(String dbInstance) {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getRDSMetricAlarmRequest(MetricName.ReadLatency, "RdsReadLatency", dbInstance);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.dbReadLatency", Double.valueOf(0.3)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRdsWriteLatencyAlarm(String dbInstance) {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getRDSMetricAlarmRequest(MetricName.WriteLatency, "RdsWriteLatency", dbInstance);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.dbWriteLatency", Double.valueOf(0.3)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRdsHighCPUAlarm(String dbInstance) {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getRDSMetricAlarmRequest(MetricName.CPUUtilization, "RdsHighCPU", dbInstance);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.dbCPUUtilization", Double.valueOf(75.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }
}

