/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.alarms;

import com.amazonaws.services.cloudwatch.model.ComparisonOperator;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Collection;
import org.onebusaway.aws.monitoring.impl.alarms.AlarmsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.alarms.RealtimeAlarms;
import org.springframework.stereotype.Component;

@Component
public class RealtimeAlarmsImpl
extends AlarmsTemplate
implements RealtimeAlarms {
    public void createRealtimeLocationsTotalAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeLocationsTotal);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtLocationsTotal", Double.valueOf(0.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeLocationsInvalidAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeLocationsInvalid);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtLocationsInvalid", Double.valueOf(30.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeStopsMatchedAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeStopsMatched);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtStopsMatched", Double.valueOf(0.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeStopsUnmatchedAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeStopsUnmatched);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtStopsUnmatched", Double.valueOf(300.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeTripsTotalAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeTripsTotal);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtTripsTotal", Double.valueOf(0.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeTripsMatchedAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeTripsMatched);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtTripsMatched", Double.valueOf(200.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeTripsUnmatchedAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeTripsUnmatched);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtTripsUnmatched", Double.valueOf(0.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createScheduleRealtimeDeltaAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.ScheduleRealtimeDelta);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtDelta", Double.valueOf(50.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeLocationsTotalPctAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeLocationsTotalPct);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Percent);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtLocationsTotalPct", Double.valueOf(10.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeInvalidLatLonPctAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeInvalidLatLonPct);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Percent);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtTnvalidLatLonPct", Double.valueOf(10.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeStopsMatchedPctAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeStopsMatchedPct);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Percent);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtStopsMatchedPct", Double.valueOf(10.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeStopsUnmatchedPctAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeStopsUnmatchedPct);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Percent);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtStopsUnmatchedPct", Double.valueOf(0.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeTripTotalPctAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeTripTotalPct);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Percent);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtTripTotalPct", Double.valueOf(10.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeTripsMatchedAvgAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeTripsMatchedAvg);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtTripsMatchedAvg", Double.valueOf(50.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createRealtimeBusesInServiceAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.RealtimeBusesInServicePct);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Percent);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.rtBusesInServicePct", Double.valueOf(0.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }
}

