/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.metrics;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import org.onebusaway.aws.monitoring.impl.metrics.MetricsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.metrics.RealtimeMetrics;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class RealtimeMetricsImpl
extends MetricsTemplate
implements RealtimeMetrics,
ApplicationListener<ContextRefreshedEvent> {
    private String watchdog_rt_location_url = "";
    private String watchdog_rt_stop_url = "";
    private String watchdog_rt_trip_url = "";
    private String watchdog_rt_delta_url = "";

    public void reloadConfig() {
        this.watchdog_rt_location_url = this._configurationService.getConfigurationValueAsString("monitoring.watchdogRealtimeLocationUrl", "http://localhost:8080/onebusaway-watchdog-webapp/api/metric/realtime/location/1/");
        this.watchdog_rt_stop_url = this._configurationService.getConfigurationValueAsString("monitoring.watchdogRealtimeStopUrl", "http://localhost:8080/onebusaway-watchdog-webapp/api/metric/realtime/stop/1/");
        this.watchdog_rt_trip_url = this._configurationService.getConfigurationValueAsString("monitoring.watchdogRealtimeTripUrl", "http://localhost:8080/onebusaway-watchdog-webapp/api/metric/realtime/trip/1/");
        this.watchdog_rt_delta_url = this._configurationService.getConfigurationValueAsString("monitoring.watchdogRealtimeDeltaUrl", "http://localhost:8080/onebusaway-watchdog-webapp/api/metric/realtime/delta/1/");
    }

    public void publishLocationMetrics() {
        this.publishWatchdogMetric(this.watchdog_rt_location_url + "total", MetricName.RealtimeLocationsTotal, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_location_url + "invalid", MetricName.RealtimeLocationsInvalid, StandardUnit.Count);
    }

    public void publishStopMetrics() {
        this.publishWatchdogMetric(this.watchdog_rt_stop_url + "matched", MetricName.RealtimeStopsMatched, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_stop_url + "unmatched", MetricName.RealtimeStopsUnmatched, StandardUnit.Count);
    }

    public void publishTripMetrics() {
        this.publishWatchdogMetric(this.watchdog_rt_trip_url + "total", MetricName.RealtimeTripsTotal, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_trip_url + "matched", MetricName.RealtimeTripsMatched, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_trip_url + "unmatched", MetricName.RealtimeTripsUnmatched, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_trip_url + "schedule-realtime-delta", MetricName.ScheduleRealtimeDelta, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_trip_url + "buses-in-service-percent", MetricName.RealtimeBusesInServicePct, StandardUnit.Count);
    }

    public void publishDeltaMetrics() {
        this.publishWatchdogMetric(this.watchdog_rt_delta_url + "location-total-pct", MetricName.RealtimeLocationsTotalPct, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_delta_url + "location-invalid-lat-lon-pct", MetricName.RealtimeInvalidLatLonPct, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_delta_url + "matched-stops-pct", MetricName.RealtimeStopsMatchedPct, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_delta_url + "unmatched-stops-pct", MetricName.RealtimeStopsUnmatchedPct, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_delta_url + "trip-total-pct", MetricName.RealtimeTripTotalPct, StandardUnit.Count);
        this.publishWatchdogMetric(this.watchdog_rt_delta_url + "average-matched-trips", MetricName.RealtimeTripsMatchedAvg, StandardUnit.Count);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.reloadConfig();
    }
}

