/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.metrics;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import org.onebusaway.aws.monitoring.impl.metrics.MetricsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.metrics.ScheduleMetrics;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class ScheduleMetricsImpl
extends MetricsTemplate
implements ScheduleMetrics,
ApplicationListener<ContextRefreshedEvent> {
    private String watchdog_schedule_url = "";

    public void reloadConfig() {
        this.watchdog_schedule_url = this._configurationService.getConfigurationValueAsString("monitoring.watchdogScheduleUrl", "http://localhost:8080/onebusaway-watchdog-webapp/api/metric/schedule/");
    }

    public void publishExpiryDateDeltaMetric() {
        String url = this.watchdog_schedule_url + "agency/1/expiry-date-delta";
        this.publishWatchdogMetric(url, MetricName.ScheduleExpiryDateDelta, StandardUnit.Count);
    }

    public void publishTotalTripsMetric() {
        String url = this.watchdog_schedule_url + "trip/1/total";
        this.publishWatchdogMetric(url, MetricName.ScheduleTotalTrips, StandardUnit.Count);
    }

    public void publishAgencyTotalMetric() {
        String url = this.watchdog_schedule_url + "agency/total";
        this.publishWatchdogMetric(url, MetricName.ScheduleAgencyTotal, StandardUnit.Count);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.reloadConfig();
    }
}

