/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.metrics;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.google.gson.JsonObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.onebusaway.aws.monitoring.impl.metrics.MetricsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.model.metrics.MetricResponse;
import org.onebusaway.aws.monitoring.service.metrics.WebappMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class WebappMetricsImpl
extends MetricsTemplate
implements WebappMetrics,
ApplicationListener<ContextRefreshedEvent> {
    protected static final Logger _log = LoggerFactory.getLogger(WebappMetricsImpl.class);
    private boolean initialized;
    private static String vehicle_monitoring_url = "";
    private String stop_monitoring_url = "";
    private String sms_webapp_url = "";
    private String nextbus_api_url = "";
    private String webapp_url = "";

    public void reloadConfig() {
        vehicle_monitoring_url = this._configurationService.getConfigurationValueAsString("monitoring.vehicleMonitoringUrl", "http://localhost:8080/onebusaway-api-webapp/siri/vehicle-monitoring?key=OBAKEY&type=xml&LineRef=70");
        this.stop_monitoring_url = this._configurationService.getConfigurationValueAsString("monitoring.stopMonitoringUrl", "http://localhost:8080/onebusaway-api-webapp/siri/stop-monitoring?key=OBAKEY&MonitoringRef=9653&type=json");
        this.sms_webapp_url = this._configurationService.getConfigurationValueAsString("monitoring.smsWebappUrl", "http://localhost:8080/onebusaway-sms-webapp/");
        this.nextbus_api_url = this._configurationService.getConfigurationValueAsString("monitoring.nextbusApiUrl", "http://localhost:8080/onebusaway-nextbus-api-webapp/service/publicJSONFeed?command=agencyList");
        this.webapp_url = this._configurationService.getConfigurationValueAsString("monitoring.webappUrl", "http://localhost:8080/");
    }

    public void publishVehicleMonitoringMetrics() {
        MetricResponse metricResponse = this.getUrlWithResponseTime(vehicle_monitoring_url);
        this.publishMetric(MetricName.VehicleMonitoringResponseTime, StandardUnit.Milliseconds, metricResponse.getResponseTime());
        this.publishMetric(MetricName.VehicleMonitoringErrorResponse, StandardUnit.Count, metricResponse.getMetric());
    }

    public void publishStopMonitoringMetrics() {
        MetricResponse metricResponse = this.getUrlWithResponseTime(this.stop_monitoring_url);
        this.publishMetric(MetricName.StopMonitoringResponseTime, StandardUnit.Milliseconds, metricResponse.getResponseTime());
        this.publishMetric(MetricName.StopMonitoringErrorResponse, StandardUnit.Count, metricResponse.getMetric());
    }

    public void publishNextBusApiMetrics() {
        double metric = 1.0;
        try {
            JsonObject agencyList = this.getJsonObject(this.nextbus_api_url);
            JsonObject agency = (JsonObject)agencyList.get("agency");
            if (agency.get("title").getAsString().equalsIgnoreCase("WMATA")) {
                metric = 0.0;
            }
            this.publishMetric(MetricName.NextBusApiErrorResponse, StandardUnit.Count, Double.valueOf(metric));
        }
        catch (Exception e) {
            _log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void publishSmsApiMetrics() {
        MetricResponse metricResponse = this.getUrlWithResponseTime(this.sms_webapp_url);
        this.publishMetric(MetricName.SMSWebappResponseTime, StandardUnit.Milliseconds, metricResponse.getResponseTime());
        this.publishMetric(MetricName.SMSWebappErrorResponse, StandardUnit.Count, metricResponse.getMetric());
    }

    public void publishDesktopUiMetrics() {
        try {
            Document doc = Jsoup.connect((String)this.webapp_url).get();
            Elements searchBar = doc.select("form[action='search.action'] > input[name='q']");
            this.publishMetric(MetricName.DesktopUiValid, StandardUnit.Count, Double.valueOf(searchBar.size()));
        }
        catch (Exception e) {
            _log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.reloadConfig();
    }
}

