/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripsForAgencyQueryBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.util.SystemTime;
import org.onebusaway.watchdog.model.Metric;
import org.onebusaway.watchdog.model.MetricConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class MetricResource {
    protected static Logger _log = LoggerFactory.getLogger(MetricResource.class);
    protected MetricConfiguration _configuration;
    protected ObjectMapper _mapper = new ObjectMapper();

    @Autowired
    public void setMetricConfiguration(MetricConfiguration mc) {
        _log.info("Setting MetricConfiguration: " + mc);
        this._configuration = mc;
    }

    protected List<MonitoredDataSource> getDataSources() {
        return this._configuration.getDataSources();
    }

    protected TransitDataService getTDS() {
        return this._configuration.getTDS();
    }

    protected int getTotalRecordCount(String agencyId, String feedId) {
        int totalRecords = 0;
        for (MonitoredDataSource mds : this.getDataSources()) {
            MonitoredResult result = mds.getMonitoredResult();
            if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
            for (String mAgencyId : result.getAgencyIds()) {
                if (!agencyId.equals(mAgencyId)) continue;
                totalRecords += result.getRecordsTotal();
            }
        }
        return totalRecords;
    }

    protected int getScheduledTrips(String agencyId) {
        return this.getScheduledTrips(agencyId, null);
    }

    protected int getScheduledTrips(String agencyId, String routeId) {
        HashSet<TripDetailsBean> agencyTrips = new HashSet<TripDetailsBean>();
        TripsForAgencyQueryBean query = new TripsForAgencyQueryBean();
        query.setAgencyId(agencyId);
        query.setMaxCount(Integer.MAX_VALUE);
        ListBean tripsForAgency = this.getTDS().getTripsForAgency(query);
        if (tripsForAgency == null) {
            return 0;
        }
        AgencyAndId routeAndId = new AgencyAndId(agencyId, routeId);
        for (TripDetailsBean trip : tripsForAgency.getList()) {
            if (trip == null || trip.getTripId() == null || !trip.getTripId().startsWith(agencyId + "_") || routeId != null && !routeAndId.toString().equals(trip.getTrip().getRoute().getId())) continue;
            agencyTrips.add(trip);
        }
        _log.debug("scheduledTrips for (" + agencyId + ", " + routeId + "): " + agencyTrips.size() + " matched trips");
        return agencyTrips.size();
    }

    protected List<String> getValidRealtimeTripIds(String agencyId, String feedId) {
        HashSet<String> tripIds = new HashSet<String>();
        for (MonitoredDataSource mds : this.getDataSources()) {
            MonitoredResult result = mds.getMonitoredResult();
            if (result == null || feedId != null && !feedId.equals(mds.getFeedId()) || agencyId == null) continue;
            for (String tripId : result.getMatchedTripIds()) {
                AgencyAndId matchedTripId;
                if (tripId == null || (matchedTripId = AgencyAndIdLibrary.convertFromString((String)tripId)) == null || !agencyId.equals(matchedTripId.getAgencyId())) continue;
                tripIds.add(tripId);
            }
            for (String tripId : result.getAddedTripIds()) {
                AgencyAndId addedTripId;
                if (tripId == null || (addedTripId = AgencyAndIdLibrary.convertFromString((String)tripId)) == null || !agencyId.equals(addedTripId.getAgencyId())) continue;
                tripIds.add(tripId);
            }
            for (String tripId : result.getDuplicatedTripIds()) {
                AgencyAndId duplicatedTripId;
                if (tripId == null || (duplicatedTripId = AgencyAndIdLibrary.convertFromString((String)tripId)) == null || !agencyId.equals(duplicatedTripId.getAgencyId())) continue;
                tripIds.add(tripId);
            }
        }
        ArrayList<String> prunedTripIds = new ArrayList<String>(tripIds.size());
        prunedTripIds.addAll(tripIds);
        return prunedTripIds;
    }

    protected int getUnmatchedTripIdCt(String agencyId, String feedId) {
        int unmatchedTripCt = 0;
        for (MonitoredDataSource mds : this.getDataSources()) {
            MonitoredResult result = mds.getMonitoredResult();
            if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
            for (String mAgencyId : result.getAgencyIds()) {
                if (!agencyId.equals(mAgencyId)) continue;
                unmatchedTripCt += result.getUnmatchedTripIds().size();
            }
        }
        return unmatchedTripCt;
    }

    protected int getAddedTripIdCt(String agencyId, String feedId) {
        int addedTripCt = 0;
        for (MonitoredDataSource mds : this.getDataSources()) {
            MonitoredResult result = mds.getMonitoredResult();
            if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
            for (String mAgencyId : result.getAgencyIds()) {
                if (!agencyId.equals(mAgencyId)) continue;
                addedTripCt += result.getAddedTripIds().size();
            }
        }
        return addedTripCt;
    }

    protected int getCancelledTripIdCt(String agencyId, String feedId) {
        int cancelledTripCt = 0;
        for (MonitoredDataSource mds : this.getDataSources()) {
            MonitoredResult result = mds.getMonitoredResult();
            if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
            for (String mAgencyId : result.getAgencyIds()) {
                if (!agencyId.equals(mAgencyId)) continue;
                cancelledTripCt += result.getCancelledTripIds().size();
            }
        }
        return cancelledTripCt;
    }

    protected int getMatchedStopCt(String agencyId, String feedId) {
        ArrayList matchedStopIds = new ArrayList();
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return 0;
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    matchedStopIds.addAll(result.getMatchedStopIds());
                }
            }
            return matchedStopIds.size();
        }
        catch (Exception e) {
            _log.error("getMatchedStopCt broke", (Throwable)e);
            return 0;
        }
    }

    protected int getUnmatchedStopCt(String agencyId, String feedId) {
        int unmatchedStops = 0;
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return 0;
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    unmatchedStops += result.getUnmatchedStopIds().size();
                }
            }
            return unmatchedStops;
        }
        catch (Exception e) {
            _log.error("getUnmatchedStopCt broke", (Throwable)e);
            return 0;
        }
    }

    protected int getLocationTotal(String agencyId, String feedId) {
        int locations = 0;
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return 0;
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    locations += result.getAllCoordinates().size();
                }
            }
            return locations;
        }
        catch (Exception e) {
            _log.error("getLocationTotal broke", (Throwable)e);
            return 0;
        }
    }

    protected int getInvalidLocation(String agencyId, String feedId) {
        int locations = 0;
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return 0;
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    locations += this.findInvalidLatLon(agencyId, result.getAllCoordinates()).size();
                }
            }
            return locations;
        }
        catch (Exception e) {
            _log.error("getInvalidLocation broke", (Throwable)e);
            return 0;
        }
    }

    protected String ok(String metricName, Object value) {
        Metric metric = new Metric();
        metric.setMetricName(metricName);
        metric.setCurrentTimestamp(SystemTime.currentTimeMillis());
        metric.setMetricValue(value);
        metric.setResponse("SUCCESS");
        try {
            return this._mapper.writeValueAsString((Object)metric);
        }
        catch (IOException e) {
            _log.error("metric serialization failed:" + e);
            return "{response=\"ERROR\"}";
        }
    }

    protected String error(String metricName, Exception e) {
        Metric metric = new Metric();
        metric.setMetricName(metricName);
        metric.setErrorMessage(e.toString());
        metric.setResponse("ERROR");
        try {
            return this._mapper.writeValueAsString((Object)metric);
        }
        catch (IOException ioe) {
            _log.error("metric serialization failed:" + ioe);
            return "{response=\"ERROR\"}";
        }
    }

    protected String error(String metricName, String errorMessage) {
        Metric metric = new Metric();
        metric.setMetricName(metricName);
        metric.setErrorMessage(errorMessage);
        metric.setResponse("ERROR");
        try {
            return this._mapper.writeValueAsString((Object)metric);
        }
        catch (IOException e) {
            _log.error("metric serialization failed:" + e);
            return "{response=\"ERROR\"}";
        }
    }

    private Collection<CoordinatePoint> findInvalidLatLon(String agencyId, Set<CoordinatePoint> coordinatePoints) {
        ArrayList<CoordinatePoint> invalid = new ArrayList<CoordinatePoint>();
        List bounds = (List)this.getTDS().getAgencyIdsWithCoverageArea().get(agencyId);
        if (bounds == null || bounds.isEmpty()) {
            _log.warn("no bounds configured for agency " + agencyId);
            for (CoordinatePoint pt : coordinatePoints) {
                invalid.add(pt);
            }
            return invalid;
        }
        for (CoordinateBounds bound : bounds) {
            boolean found = false;
            for (CoordinatePoint pt : coordinatePoints) {
                if (bound.contains(pt)) {
                    found = true;
                }
                if (found) continue;
                invalid.add(pt);
            }
        }
        _log.debug("agency " + agencyId + " had " + invalid.size() + " invalid out of " + coordinatePoints.size());
        return invalid;
    }
}

