/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Request;
import org.onebusaway.watchdog.api.RESTEndpointsDocumenter;

public class RESTEndpointsDocumenter {
    static final String NEWLINE = System.getProperty("line.separator");

    public List<Endpoint> findRESTEndpoints(String basepackage) throws IOException, ClassNotFoundException {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        List classes = this.getClasses(basepackage);
        for (Class clazz : classes) {
            Method[] methods;
            Path annotation = clazz.getAnnotation(Path.class);
            if (annotation == null) continue;
            String basePath = this.getRESTEndpointPath(clazz);
            for (Method method : methods = clazz.getMethods()) {
                if (method.isAnnotationPresent(GET.class)) {
                    endpoints.add(this.createEndpoint(method, MethodEnum.GET, clazz, basePath));
                    continue;
                }
                if (method.isAnnotationPresent(PUT.class)) {
                    endpoints.add(this.createEndpoint(method, MethodEnum.PUT, clazz, basePath));
                    continue;
                }
                if (method.isAnnotationPresent(POST.class)) {
                    endpoints.add(this.createEndpoint(method, MethodEnum.POST, clazz, basePath));
                    continue;
                }
                if (!method.isAnnotationPresent(DELETE.class)) continue;
                endpoints.add(this.createEndpoint(method, MethodEnum.DELETE, clazz, basePath));
            }
        }
        return endpoints;
    }

    private Endpoint createEndpoint(Method javaMethod, MethodEnum restMethod, Class<?> clazz, String classUri) {
        Endpoint newEndpoint = new Endpoint(this);
        newEndpoint.method = restMethod;
        newEndpoint.javaMethodName = javaMethod.getName();
        newEndpoint.javaClass = clazz.getName();
        Path path = javaMethod.getAnnotation(Path.class);
        newEndpoint.uri = path != null ? classUri + path.value() : classUri;
        this.discoverParameters(javaMethod, newEndpoint);
        return newEndpoint;
    }

    private void discoverParameters(Method method, Endpoint endpoint) {
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        block5: for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] parameterAnnotations;
            Class<?> parameter = parameterTypes[i];
            if (parameter == Request.class || parameter == HttpServletResponse.class || parameter == HttpServletRequest.class) continue;
            EndpointParameter nextParameter = new EndpointParameter(this);
            nextParameter.javaType = parameter.getName();
            for (Annotation annotation : parameterAnnotations = annotations[i]) {
                if (annotation instanceof PathParam) {
                    nextParameter.parameterType = ParameterType.PATH;
                    PathParam pathparam = (PathParam)annotation;
                    nextParameter.name = pathparam.value();
                    continue;
                }
                if (annotation instanceof QueryParam) {
                    nextParameter.parameterType = ParameterType.QUERY;
                    QueryParam queryparam = (QueryParam)annotation;
                    nextParameter.name = queryparam.value();
                    continue;
                }
                if (!(annotation instanceof DefaultValue)) continue;
                DefaultValue defaultvalue = (DefaultValue)annotation;
                nextParameter.defaultValue = defaultvalue.value();
            }
            switch (1.$SwitchMap$org$onebusaway$watchdog$api$RESTEndpointsDocumenter$ParameterType[nextParameter.parameterType.ordinal()]) {
                case 1: {
                    endpoint.pathParameters.add(nextParameter);
                    continue block5;
                }
                case 2: {
                    endpoint.queryParameters.add(nextParameter);
                    continue block5;
                }
                case 3: {
                    endpoint.payloadParameters.add(nextParameter);
                }
            }
        }
    }

    private String getRESTEndpointPath(Class<?> clazz) {
        Object path = "";
        while (clazz != null) {
            Path annotation = clazz.getAnnotation(Path.class);
            if (annotation != null) {
                path = annotation.value() + (String)path;
            }
            if (path == null) continue;
            break;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }

    private List<Class> getClasses(String pkg) throws IOException, ClassNotFoundException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        String path = pkg.replace('.', '/');
        Enumeration<URL> resources = classloader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(this.getClasses(directory, pkg));
        }
        return classes;
    }

    private List<Class> getClasses(File dir, String pkg) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!dir.exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(this.getClasses(file, pkg + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(pkg + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

