/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.watchdog.api.MetricResource;
import org.onebusaway.watchdog.api.RESTEndpointsDocumenter;

@Path(value="/metric")
public class RootResource
extends MetricResource {
    private static final String DEFAULT_API_PATH = "/onebusaway-watchdog-webapp/api";

    @Path(value="ping")
    @GET
    @Produces(value={"application/json"})
    public Response ping() {
        try {
            this.getTDS().getAgenciesWithCoverage();
            return Response.ok((Object)this.ok("ping", (Object)1)).build();
        }
        catch (Exception e) {
            _log.error("ping broke", (Throwable)e);
            return Response.ok((Object)this.error("ping", e)).build();
        }
    }

    @Path(value="list-uris")
    @GET
    @Produces(value={"application/json"})
    public Response listUris() {
        try {
            RESTEndpointsDocumenter red = new RESTEndpointsDocumenter();
            List endpoints = red.findRESTEndpoints("org.onebusaway.watchdog.api");
            StringBuffer json = new StringBuffer();
            json.append("[");
            for (RESTEndpointsDocumenter.Endpoint e : endpoints) {
                json.append("\"");
                json.append(e.uri);
                json.append("\"");
                json.append(",");
            }
            json.deleteCharAt(json.length() - 1);
            json.append("]");
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @Path(value="list-agencies")
    @GET
    @Produces(value={"application/json"})
    public Response listAgencies() {
        List agenciesWithCoverage = this.getTDS().getAgenciesWithCoverage();
        ArrayList<String> agencyIds = new ArrayList<String>();
        for (AgencyWithCoverageBean bean : agenciesWithCoverage) {
            agencyIds.add(bean.getAgency().getId());
        }
        Collections.sort(agencyIds);
        StringBuffer json = new StringBuffer();
        json.append("[");
        for (String agency : agencyIds) {
            json.append("\"");
            json.append(agency);
            json.append("\"");
            json.append(",");
        }
        json.deleteCharAt(json.length() - 1);
        json.append("]");
        return Response.ok((Object)json.toString()).build();
    }
}

