/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api.realtime;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onebusaway.watchdog.api.LongTermAveragesResource;

@Path(value="/metric/realtime/delta")
public class AveragesResource
extends LongTermAveragesResource {
    @Path(value="{agencyId}/average-matched-trips")
    @GET
    @Produces(value={"application/json"})
    public Response getLongTermDeltaMatched(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("long-term-delta-matched-trips", "no configured data sources")).build();
            }
            int validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, feedId).size();
            int average = this.getAvgByAgency("matched-trips-average", agencyId);
            int longTermDelta = validRealtimeTrips - average;
            _log.debug("current: " + validRealtimeTrips + ", average: " + average);
            return Response.ok((Object)this.ok("long-term-delta-matched-trips", (Object)longTermDelta)).build();
        }
        catch (Exception e) {
            _log.error("getMatchedTripCount broke", (Throwable)e);
            return Response.ok((Object)this.error("matched-trips", e)).build();
        }
    }

    @Path(value="{agencyId}/average-matched-trips-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getLongTermDeltaMatchedPct(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("long-term-delta-matched-trips-pct", "no configured data sources")).build();
            }
            int validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, feedId).size();
            int average = this.getAvgByAgency("matched-trips-average", agencyId);
            int longTermDeltaPct = average != 0 ? (int)Math.round((double)(validRealtimeTrips - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("current matched: " + validRealtimeTrips + ", average: " + average);
            return Response.ok((Object)this.ok("long-term-delta-matched-trips-pct", (Object)longTermDeltaPct)).build();
        }
        catch (Exception e) {
            _log.error("getMatchedTripCount broke", (Throwable)e);
            return Response.ok((Object)this.error("matched-trips-pct", e)).build();
        }
    }

    @Path(value="{agencyId}/average-unmatched-trips")
    @GET
    @Produces(value={"application/json"})
    public Response getLongTermDeltaUnmatched(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("unmatched-trips", "no configured data sources")).build();
            }
            int unmatchedTrips = this.getUnmatchedTripIdCt(agencyId, feedId);
            int average = this.getAvgByAgency("unmatched-trips-average", agencyId);
            int longTermDelta = unmatchedTrips - average;
            _log.debug("current: " + unmatchedTrips + ", average: " + average);
            return Response.ok((Object)this.ok("long-term-delta-unmatched-trips", (Object)longTermDelta)).build();
        }
        catch (Exception e) {
            _log.error("getUnmatchedTrips broke", (Throwable)e);
            return Response.ok((Object)this.error("unmatched-trips", e)).build();
        }
    }

    @Path(value="{agencyId}/average-unmatched-trips-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getLongTermDeltaUnmatchedPct(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            int unmatchedTrips = this.getUnmatchedTripIdCt(agencyId, feedId);
            int average = this.getAvgByAgency("unmatched-trips-average", agencyId);
            int longTermDeltaPct = average != 0 ? (int)Math.round((double)(unmatchedTrips - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("current unmatched: " + unmatchedTrips + ", average: " + average);
            return Response.ok((Object)this.ok("unmatched-trips", (Object)longTermDeltaPct)).build();
        }
        catch (Exception e) {
            _log.error("getUnmatchedTrips broke", (Throwable)e);
            return Response.ok((Object)this.error("unmatched-trips", e)).build();
        }
    }

    @Path(value="{agencyId}/buses-in-service-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getBusesInServicePct(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId, @QueryParam(value="routeId") String routeId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("buses-in-service-pct", "no configured data sources")).build();
            }
            int scheduledTrips = this.getScheduledTrips(agencyId, routeId);
            int validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, feedId).size();
            int percent = (int)Math.round((double)validRealtimeTrips * 100.0 / (double)scheduledTrips);
            int average = this.getAvgByAgency("buses-in-service-pct", agencyId);
            int longTermDeltaPct = average != 0 ? (int)Math.round((double)(percent - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("current pct in service: " + percent + ", average: " + average);
            return Response.ok((Object)this.ok("long-term-delta-matched-trips-pct", (Object)longTermDeltaPct)).build();
        }
        catch (Exception e) {
            _log.error("getBusesInServicePct broke", (Throwable)e);
            return Response.ok((Object)this.error("buses-in-service-pct", e)).build();
        }
    }

    @Path(value="{agencyId}/matched-stops-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getMatchedStops(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("matched-stops", "no configured data sources")).build();
            }
            int matched = this.getMatchedStopCt(agencyId, feedId);
            int average = this.getAvgByAgency("matched-stops", agencyId);
            int percent = average != 0 ? (int)Math.round((double)(matched - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("current matched stops: " + matched + ", average: " + average);
            return Response.ok((Object)this.ok("matched-stops-pct", (Object)percent)).build();
        }
        catch (Exception e) {
            _log.error("getMatchedStops broke", (Throwable)e);
            return Response.ok((Object)this.error("matched-stops-pct", e)).build();
        }
    }

    @Path(value="{agencyId}/unmatched-stops-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getUnmatchedStops(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("unmatched-stops", "no configured data sources")).build();
            }
            int unmatched = this.getUnmatchedStopCt(agencyId, feedId);
            int average = this.getAvgByAgency("unmatched-stops", agencyId);
            int percent = average != 0 ? (int)Math.round((double)(unmatched - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("current unmatched stops: " + unmatched + ", average: " + average);
            return Response.ok((Object)this.ok("unmatched-stops-pct", (Object)percent)).build();
        }
        catch (Exception e) {
            _log.error("getUnmatchedStops broke", (Throwable)e);
            return Response.ok((Object)this.error("unmatched-stops-pct", e)).build();
        }
    }

    @Path(value="{agencyId}/trip-total-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getTripTotalPct(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("trip-total-pct", "no configured data sources")).build();
            }
            int total = this.getTotalRecordCount(agencyId, feedId);
            int average = this.getAvgByAgency("trip-total", agencyId);
            int percent = average != 0 ? (int)Math.round((double)(total - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("trip-total: " + total + ", average: " + average);
            return Response.ok((Object)this.ok("trip-total-pct", (Object)percent)).build();
        }
        catch (Exception e) {
            _log.error("getTripTotalPct broke", (Throwable)e);
            return Response.ok((Object)this.error("trip-total-pct", e)).build();
        }
    }

    @Path(value="{agencyId}/trip-schedule-realtime-diff-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getTripScheduleRealtimeDiff(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId, @QueryParam(value="routeId") String routeId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("trip-schedule-realtime-diff-pct", "no configured data sources")).build();
            }
            int scheduledTrips = this.getScheduledTrips(agencyId, routeId);
            int validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, feedId).size();
            int diff = scheduledTrips - validRealtimeTrips;
            int average = this.getAvgByAgency("trip-schedule-realtime-diff", agencyId);
            int percent = average != 0 ? (int)Math.round((double)(diff - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("trip-schedule-realtime-diff: " + diff + ", average: " + average);
            return Response.ok((Object)this.ok("trip-schedule-realtime-diff-pct", (Object)percent)).build();
        }
        catch (Exception e) {
            _log.error("getTripScheduleRealtimeDiff broke", (Throwable)e);
            return Response.ok((Object)this.error("trip-schedule-realtime-diff-pct", e)).build();
        }
    }

    @Path(value="{agencyId}/location-total-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getLocationTotalPct(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("location-total-pct", "no configured data sources")).build();
            }
            int total = this.getLocationTotal(agencyId, feedId);
            int average = this.getAvgByAgency("location-total", agencyId);
            int percent = average != 0 ? (int)Math.round((double)(total - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("location-total: " + total + ", average: " + average);
            return Response.ok((Object)this.ok("location-total-pct", (Object)percent)).build();
        }
        catch (Exception e) {
            _log.error("getLocationTotal broke", (Throwable)e);
            return Response.ok((Object)this.error("location-total-pct", e)).build();
        }
    }

    @Path(value="{agencyId}/location-invalid-lat-lon-pct")
    @GET
    @Produces(value={"application/json"})
    public Response getLocationInvalidPct(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("location-invalid-lat-lon-pct", "no configured data sources")).build();
            }
            int total = this.getInvalidLocation(agencyId, feedId);
            int average = this.getAvgByAgency("location-invalid-lat-lon", agencyId);
            int percent = average != 0 ? (int)Math.round((double)(total - average) * 100.0 / (double)average) : Integer.MAX_VALUE;
            _log.debug("location-invalid-lat-lon: " + total + ", average: " + average);
            return Response.ok((Object)this.ok("location-invalid-lat-lon-pct", (Object)percent)).build();
        }
        catch (Exception e) {
            _log.error("getLocationInvalidPct broke", (Throwable)e);
            return Response.ok((Object)this.error("location-invalid-lat-lon-pct", e)).build();
        }
    }
}

