/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api.realtime;

import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.watchdog.api.MetricResource;

@Path(value="/metric/realtime/stop")
public class StopResource
extends MetricResource {
    @Path(value="{agencyId}/matched")
    @GET
    @Produces(value={"application/json"})
    public Response getMatchedStopCount(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        ArrayList<String> matchedStopIds = new ArrayList<String>();
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("matched-stops", "con configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    for (String stopId : result.getMatchedStopIds()) {
                        matchedStopIds.add(stopId);
                    }
                }
            }
            return Response.ok((Object)this.ok("matched-stops", (Object)matchedStopIds.size())).build();
        }
        catch (Exception e) {
            _log.error("getMatchedStopCount broke", (Throwable)e);
            return Response.ok((Object)this.error("matched-stops", e)).build();
        }
    }

    @Path(value="{agencyId}/unmatched")
    @GET
    @Produces(value={"application/json"})
    public Response getUnmatchedStops(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            int unmatchedStops = 0;
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("unmatched-stops", "no configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    _log.debug("examining agency=" + mAgencyId + " with unmatched stops=" + result.getUnmatchedStopIds().size());
                    if (!agencyId.equals(mAgencyId)) continue;
                    unmatchedStops += result.getUnmatchedStopIds().size();
                }
            }
            return Response.ok((Object)this.ok("unmatched-stops", (Object)unmatchedStops)).build();
        }
        catch (Exception e) {
            _log.error("getUnmatchedStops broke", (Throwable)e);
            return Response.ok((Object)this.error("unmatched-stops", e)).build();
        }
    }

    @Path(value="{agencyId}/unmatched-ids")
    @GET
    @Produces(value={"application/json"})
    public Response getUnmatchedStopIds(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            ArrayList unmatchedStopIds = new ArrayList();
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("unmatched-stop-ids", "con configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    unmatchedStopIds.addAll(result.getUnmatchedStopIds());
                }
            }
            return Response.ok((Object)this.ok("unmatched-stop-ids", unmatchedStopIds)).build();
        }
        catch (Exception e) {
            _log.error("getUnmatchedStopIds broke", (Throwable)e);
            return Response.ok((Object)this.error("unmatched-stop-ids", e)).build();
        }
    }
}

