/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api.realtime;

import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.watchdog.api.MetricResource;

@Path(value="/metric/realtime/trip")
public class TripResource
extends MetricResource {
    @Path(value="{agencyId}/total")
    @GET
    @Produces(value={"application/json"})
    public Response getTotalRecords(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            int totalRecords = 0;
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("total-records", "no configured data sources")).build();
            }
            totalRecords = this.getTotalRecordCount(agencyId, feedId);
            return Response.ok((Object)this.ok("total-records", (Object)totalRecords)).build();
        }
        catch (Exception e) {
            _log.error("getTotalRecords broke", (Throwable)e);
            return Response.ok((Object)this.error("total-records", e)).build();
        }
    }

    @Path(value="{agencyId}/matched")
    @GET
    @Produces(value={"application/json"})
    public Response getMatchedTripCount(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("matched-trips", "con configured data sources")).build();
            }
            int validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, feedId).size();
            return Response.ok((Object)this.ok("matched-trips", (Object)validRealtimeTrips)).build();
        }
        catch (Exception e) {
            _log.error("getMatchedTripCount broke", (Throwable)e);
            return Response.ok((Object)this.error("matched-trips", e)).build();
        }
    }

    @Path(value="{agencyId}/unmatched")
    @GET
    @Produces(value={"application/json"})
    public Response getUnmatchedTrips(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            int unmatchedTrips = 0;
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("unmatched-trips", "no configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    _log.debug("examining agency=" + mAgencyId + " with unmatched trips=" + result.getUnmatchedTripIds().size());
                    if (!agencyId.equals(mAgencyId)) continue;
                    unmatchedTrips += result.getUnmatchedTripIds().size();
                }
            }
            return Response.ok((Object)this.ok("unmatched-trips", (Object)unmatchedTrips)).build();
        }
        catch (Exception e) {
            _log.error("getUnmatchedTrips broke", (Throwable)e);
            return Response.ok((Object)this.error("unmatched-trips", e)).build();
        }
    }

    @Path(value="{agencyId}/cancelled")
    @GET
    @Produces(value={"application/json"})
    public Response getCancelledTrips(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            int cancelledTrips = 0;
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("cancelled-trips", "no configured data sources")).build();
            }
            cancelledTrips = this.getCancelledTripIdCt(agencyId, feedId);
            return Response.ok((Object)this.ok("cancelled-trips", (Object)cancelledTrips)).build();
        }
        catch (Exception e) {
            _log.error("getcancelledTrips broke", (Throwable)e);
            return Response.ok((Object)this.error("cancelled-trips", e)).build();
        }
    }

    @Path(value="{agencyId}/added")
    @GET
    @Produces(value={"application/json"})
    public Response getAddedTrips(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            int addedTrips = 0;
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("added-trips", "no configured data sources")).build();
            }
            addedTrips = this.getAddedTripIdCt(agencyId, feedId);
            return Response.ok((Object)this.ok("added-trips", (Object)addedTrips)).build();
        }
        catch (Exception e) {
            _log.error("getAddedTrips broke", (Throwable)e);
            return Response.ok((Object)this.error("added-trips", e)).build();
        }
    }

    @Path(value="{agencyId}/unmatched-ids")
    @GET
    @Produces(value={"application/json"})
    public Response getUnmatchedTripIds(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            ArrayList unmatchedTripIds = new ArrayList();
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("unmatched-trip-ids", "con configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    unmatchedTripIds.addAll(result.getUnmatchedTripIds());
                }
            }
            return Response.ok((Object)this.ok("unmatched-trip-ids", unmatchedTripIds)).build();
        }
        catch (Exception e) {
            _log.error("getUnmatchedTripIds broke", (Throwable)e);
            return Response.ok((Object)this.error("unmatched-trip-ids", e)).build();
        }
    }

    @Path(value="{agencyId}/cancelled-ids")
    @GET
    @Produces(value={"application/json"})
    public Response getCancelledTripIds(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            ArrayList cancelledTripIds = new ArrayList();
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("cancelled-trip-ids", "con configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    cancelledTripIds.addAll(result.getCancelledTripIds());
                }
            }
            return Response.ok((Object)this.ok("cancelled-trip-ids", cancelledTripIds)).build();
        }
        catch (Exception e) {
            _log.error("getCancelledTripIds broke", (Throwable)e);
            return Response.ok((Object)this.error("cancelled-trip-ids", e)).build();
        }
    }

    @Path(value="{agencyId}/added-ids")
    @GET
    @Produces(value={"application/json"})
    public Response getAddedTripIds(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId) {
        try {
            ArrayList addedTripIds = new ArrayList();
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("added-trip-ids", "con configured data sources")).build();
            }
            for (MonitoredDataSource mds : this.getDataSources()) {
                MonitoredResult result = mds.getMonitoredResult();
                if (result == null || feedId != null && !feedId.equals(mds.getFeedId())) continue;
                for (String mAgencyId : result.getAgencyIds()) {
                    if (!agencyId.equals(mAgencyId)) continue;
                    addedTripIds.addAll(result.getAddedTripIds());
                }
            }
            return Response.ok((Object)this.ok("added-trip-ids", addedTripIds)).build();
        }
        catch (Exception e) {
            _log.error("getAddedTripIds broke", (Throwable)e);
            return Response.ok((Object)this.error("added-trip-ids", e)).build();
        }
    }

    @Path(value="{agencyId}/schedule-realtime-delta")
    @GET
    @Produces(value={"application/json"})
    public Response getScheduleRealtimeTripsDelta(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId, @QueryParam(value="routeId") String routeId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("schedule-realtime-trips-delta", "con configured data sources")).build();
            }
            int scheduleTrips = this.getScheduledTrips(agencyId, routeId);
            int totalRecords = this.getTotalRecordCount(agencyId, feedId);
            int validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, feedId).size();
            _log.debug("agencytrips size=" + scheduleTrips + ", validRealtimeTrips=" + validRealtimeTrips + ", totalRecords=" + totalRecords);
            int delta = scheduleTrips - validRealtimeTrips;
            return Response.ok((Object)this.ok("schedule-realtime-trips-delta", (Object)delta)).build();
        }
        catch (Exception e) {
            _log.error("getScheduledRealtimeTripsDelta broke", (Throwable)e);
            return Response.ok((Object)this.error("schedule-realtime-trips-delta", e)).build();
        }
    }

    @Path(value="{agencyId}/buses-in-service-percent")
    @GET
    @Produces(value={"application/json"})
    public Response getBusesInServicePercent(@PathParam(value="agencyId") String agencyId, @QueryParam(value="feedId") String feedId, @QueryParam(value="routeId") String routeId) {
        try {
            if (this.getDataSources() == null || this.getDataSources().isEmpty()) {
                _log.error("no configured data sources");
                return Response.ok((Object)this.error("buses-in-service-percent", "con configured data sources")).build();
            }
            double scheduleTrips = this.getScheduledTrips(agencyId, routeId);
            if (scheduleTrips < 1.0) {
                return Response.ok((Object)this.ok("buses-in-service-percent", (Object)0.0)).build();
            }
            double validRealtimeTrips = this.getValidRealtimeTripIds(agencyId, feedId).size();
            double cancelledTrips = this.getCancelledTripIdCt(agencyId, feedId);
            double addedTrips = this.getAddedTripIdCt(agencyId, feedId);
            _log.info("agencytrips size=" + scheduleTrips + ", validRealtimeTrips=" + validRealtimeTrips + " cancelled=" + cancelledTrips + ", addedTrips=" + addedTrips + " for feedId=" + feedId + ", routeId=" + routeId);
            double percent = Math.abs((validRealtimeTrips - cancelledTrips) / scheduleTrips * 100.0);
            return Response.ok((Object)this.ok("buses-in-service-percent", (Object)percent)).build();
        }
        catch (Exception e) {
            _log.error("getBusesInServicePercent broke", (Throwable)e);
            return Response.ok((Object)this.error("buses-in-service-percent", e)).build();
        }
    }
}

