/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.watchdog.api.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.watchdog.api.MetricResource;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/metric/schedule/agency")
public class AgencyResource
extends MetricResource {
    static Map<String, Date> agencyEndDateMap = new HashMap();
    private CalendarService _calendarService;
    private TransitGraphDao _graph;

    @Autowired
    public void setCalendarService(CalendarService calendarService) {
        this._calendarService = calendarService;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao graph) {
        this._graph = graph;
    }

    @PostConstruct
    @Refreshable(dependsOn={"calendarData"})
    public void start() {
        _log.info("Need to clear agencyEndDateMap");
        agencyEndDateMap.clear();
    }

    @Path(value="total")
    @GET
    @Produces(value={"application/json"})
    public Response getAgencyCount() {
        try {
            int count = this.getTDS().getAgenciesWithCoverage().size();
            return Response.ok((Object)this.ok("agency-count", (Object)count)).build();
        }
        catch (Exception e) {
            _log.error("getAgencyCount broke", (Throwable)e);
            return Response.ok((Object)this.error("agency-count", e)).build();
        }
    }

    @Path(value="id-list")
    @GET
    @Produces(value={"application/json"})
    public Response getAgencyIdList() {
        try {
            List agencyBeans = this.getTDS().getAgenciesWithCoverage();
            ArrayList<String> agencyIds = new ArrayList<String>();
            for (AgencyWithCoverageBean agency : agencyBeans) {
                agencyIds.add(agency.getAgency().getId());
            }
            return Response.ok((Object)this.ok("agency-id-list", agencyIds)).build();
        }
        catch (Exception e) {
            _log.error("getAgencyIdList broke", (Throwable)e);
            return Response.ok((Object)this.error("agency-id-list", e)).build();
        }
    }

    @Path(value="{agencyId}/expiry-date-delta")
    @GET
    @Produces(value={"application/json"})
    public Response getAgencyExpiryDateDelta(@PathParam(value="agencyId") String agencyId) {
        try {
            Date endDate = (Date)agencyEndDateMap.get(agencyId);
            if (endDate == null) {
                _log.info("Service end date for agency " + agencyId + " not cached.  Reloading");
                List trips = this._graph.getAllTrips();
                HashSet<AgencyAndId> tripSvcIds = new HashSet<AgencyAndId>();
                for (Object trip : trips) {
                    if (!trip.getRoute().getId().getAgencyId().equals(agencyId)) continue;
                    tripSvcIds.add(trip.getServiceId().getId());
                }
                HashSet serviceDates = new HashSet();
                for (AgencyAndId serviceId : tripSvcIds) {
                    serviceDates.addAll(this._calendarService.getServiceDatesForServiceId(serviceId));
                }
                Object[] serviceDateArray = serviceDates.toArray(new ServiceDate[serviceDates.size()]);
                Arrays.sort(serviceDateArray);
                if (serviceDateArray.length > 0) {
                    endDate = serviceDateArray[serviceDateArray.length - 1].getAsDate();
                    agencyEndDateMap.put(agencyId, endDate);
                } else {
                    endDate = new Date(0L);
                }
            }
            Calendar latestSvcDate = Calendar.getInstance();
            latestSvcDate.setTime(endDate);
            int delta = AgencyResource.deltaInDays((Calendar)Calendar.getInstance(), (Calendar)latestSvcDate);
            return Response.ok((Object)this.ok("agency-expiry-date-delta", (Object)delta)).build();
        }
        catch (Exception e) {
            _log.error("getAgencyExpiryDateDelta broke", (Throwable)e);
            return Response.ok((Object)this.error("agency-expiry-date-delta", e)).build();
        }
    }

    private static int deltaInDays(Calendar startDate, Calendar endDate) {
        Calendar date = (Calendar)startDate.clone();
        int delta = 0;
        while (date.before(endDate)) {
            date.add(5, 1);
            ++delta;
        }
        return delta;
    }
}

