/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs;

import java.util.LinkedHashMap;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrSessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@CrossOriginResourceSharing(allowAllOrigins=true)
public class RootResource {
    private static final Logger log = LoggerFactory.getLogger(RootResource.class);
    public static final String UNKNOWN = "unknown";
    @Context
    private HttpServletRequest request;

    @GET
    @Produces(value={"application/json"})
    public Response getInstanceInformation() {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> vendor = new LinkedHashMap<String, String>();
        Session session = JcrSessionUtil.getSessionFromRequest(this.request);
        info.put("clusterid", this.getClusterNodeId(session));
        vendor.put("name", this.getRepositoryVendor(session));
        vendor.put("version", this.getRepositoryVersion(session));
        info.put("vendor", vendor);
        return Response.ok(info).build();
    }

    private String getClusterNodeId(Session session) {
        String clusterId;
        String emptyClusterNodeId = "";
        if (session.getRepository() != null && StringUtils.isNotBlank((String)(clusterId = session.getRepository().getDescriptor("jackrabbit.cluster.id")))) {
            return clusterId;
        }
        return emptyClusterNodeId;
    }

    private String getRepositoryVersion(Session session) {
        Repository repository = session.getRepository();
        if (repository != null) {
            return repository.getDescriptor("jcr.repository.version");
        }
        return UNKNOWN;
    }

    private String getRepositoryVendor(Session session) {
        Repository repository = session.getRepository();
        if (repository != null) {
            return repository.getDescriptor("jcr.repository.name");
        }
        return UNKNOWN;
    }
}

