/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.jcr;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.annotations.GZIP;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.onehippo.forge.webservices.jaxrs.jcr.NodesResource;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrNode;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrProperty;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrDataBindingHelper;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrSessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GZIP
@Api(value="properties", description="JCR property API", position=3)
@Path(value="v1/properties")
@CrossOriginResourceSharing(allowAllOrigins=true)
public class PropertiesResource {
    private static final Logger log = LoggerFactory.getLogger(NodesResource.class);
    @Context
    private HttpServletRequest request;

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get a property", notes="Returns a property from the specified path")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=JcrNode.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getPropertyByPath(@ApiParam(value="Path of the node to retrieve e.g '/content/hippostd:foldertype'.", required=true) @PathParam(value="path") String path) throws RepositoryException {
        JcrProperty jcrProperty = null;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            String absolutePath = StringUtils.defaultIfEmpty((String)path, (String)"/");
            if (!absolutePath.startsWith("/")) {
                absolutePath = "/" + absolutePath;
            }
            if (!session.propertyExists(absolutePath)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Property property = session.getProperty(absolutePath);
            jcrProperty = JcrDataBindingHelper.getPropertyRepresentation(property);
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)jcrProperty).build();
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Add a property to a node", notes="Adds a property to a node")
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=JcrProperty.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=403, message="Access denied"), @ApiResponse(code=500, message="Error occurred")})
    public Response createPropertyByPath(@ApiParam(required=true, value="Path of the node to which to add the property to e.g. '/content/documents/'") @PathParam(value="path") @DefaultValue(value="/") String parentPath, @Context UriInfo ui, JcrProperty jcrProperty) throws RepositoryException {
        URI newPropertyUri = null;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            String absolutePath = StringUtils.defaultIfEmpty((String)parentPath, (String)"/");
            if (!absolutePath.startsWith("/")) {
                absolutePath = "/" + absolutePath;
            }
            if (!session.nodeExists(absolutePath)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isEmpty((String)jcrProperty.getName())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isEmpty((String)jcrProperty.getType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Node parentNode = session.getNode(absolutePath);
            JcrDataBindingHelper.addPropertyToNode(parentNode, jcrProperty);
            session.save();
            UriBuilder ub = ui.getBaseUriBuilder().path(this.getClass()).path(this.getClass(), "getPropertyByPath");
            newPropertyUri = ub.build(new Object[]{parentNode.getProperty(jcrProperty.getName()).getPath().substring(1)});
        }
        catch (Exception e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.created((URI)newPropertyUri).build();
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Updates a property of a node", notes="Updates a property of a node")
    @ApiResponses(value={@ApiResponse(code=204, message="Updated"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Property not found"), @ApiResponse(code=403, message="Access denied"), @ApiResponse(code=500, message="Error occurred")})
    public Response updatePropertyByPath(@ApiParam(required=true, value="Path of the property to update e.g. '/content/documents/hippostd:foldertypes'") @PathParam(value="path") @DefaultValue(value="/") String parentPath, @Context UriInfo ui, JcrProperty jcrProperty) throws RepositoryException {
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            String absolutePath = StringUtils.defaultIfEmpty((String)parentPath, (String)"/");
            if (!absolutePath.startsWith("/")) {
                absolutePath = "/" + absolutePath;
            }
            if (!session.propertyExists(absolutePath)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isEmpty((String)jcrProperty.getName())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isEmpty((String)jcrProperty.getType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Property property = session.getProperty(absolutePath);
            Node node = property.getParent();
            JcrDataBindingHelper.addPropertyToNode(node, jcrProperty);
            session.save();
        }
        catch (Exception e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{path:.*}")
    @ApiOperation(value="Delete a property", notes="Deletes a property")
    @ApiResponses(value={@ApiResponse(code=204, message="Deleted"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response deletePropertyByPath(@ApiParam(required=true, value="Path of the property to delete e.g. '/content/hippostd:foldertype'.") @PathParam(value="path") String path) throws RepositoryException {
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            String absolutePath = path;
            if (!absolutePath.startsWith("/")) {
                absolutePath = "/" + absolutePath;
            }
            if (StringUtils.isBlank((String)path)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!session.propertyExists(absolutePath)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Property property = session.getProperty(absolutePath);
            property.remove();
            session.save();
        }
        catch (Exception e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.noContent().build();
    }
}

