/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.jcr.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.value.ValueHelper;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrNode;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JcrDataBindingHelper {
    private static final Logger log = LoggerFactory.getLogger(JcrDataBindingHelper.class);
    private static final Map<Integer, String> PROPERTY_BLACKLIST = JcrDataBindingHelper.ignoreMap();

    private static Map<Integer, String> ignoreMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "hippo:paths");
        result.put(2, "hippo:related");
        result.put(3, "jcr:primaryType");
        result.put(4, "jcr:mixinTypes");
        result.put(5, "jcr:uuid");
        return Collections.unmodifiableMap(result);
    }

    private JcrDataBindingHelper() {
        throw new UnsupportedOperationException();
    }

    public static JcrNode getNodeRepresentation(Node node, int depth) {
        JcrNode jcrNode = new JcrNode();
        try {
            jcrNode.setName(node.getName());
            jcrNode.setIdentifier(node.getIdentifier());
            jcrNode.setPath(node.getPath());
            jcrNode.setPrimaryType(node.getPrimaryNodeType().getName());
            NodeType[] mixinNodeTypes = node.getMixinNodeTypes();
            if (mixinNodeTypes != null) {
                ArrayList<String> mixins = new ArrayList<String>(mixinNodeTypes.length);
                for (NodeType mixinNodeType : mixinNodeTypes) {
                    mixins.add(mixinNodeType.getName());
                }
                jcrNode.setMixinTypes(mixins);
            }
            PropertyIterator properties = node.getProperties();
            while (properties.hasNext()) {
                Property property = properties.nextProperty();
                if (PROPERTY_BLACKLIST.containsValue(property.getName())) continue;
                jcrNode.getProperties().add(JcrDataBindingHelper.getPropertyRepresentation(property));
            }
            if (depth > 0 && node.hasNodes()) {
                NodeIterator childNodes = node.getNodes();
                while (childNodes.hasNext()) {
                    jcrNode.addNode(JcrDataBindingHelper.getNodeRepresentation(childNodes.nextNode(), depth - 1));
                }
            }
        }
        catch (RepositoryException e) {
            log.error("An exception occurred while trying to marshall node: {} ", (Throwable)e);
        }
        return jcrNode;
    }

    public static JcrProperty getPropertyRepresentation(Property property) throws RepositoryException {
        JcrProperty data = new JcrProperty();
        data.setName(property.getName());
        data.setType(PropertyType.nameFromValue((int)property.getType()));
        data.setMultiple(property.isMultiple());
        ArrayList<String> values = new ArrayList<String>();
        if (property.isMultiple()) {
            for (Value propertyValue : property.getValues()) {
                values.add(JcrDataBindingHelper.getPropertyValueAsString(propertyValue));
            }
        } else {
            values.add(JcrDataBindingHelper.getPropertyValueAsString(property.getValue()));
        }
        data.setValues(values);
        return data;
    }

    private static String getPropertyValueAsString(Value value) throws RepositoryException {
        StringWriter stringWriter = new StringWriter();
        if (value.getType() == 2) {
            try {
                ValueHelper.serialize((Value)value, (boolean)false, (boolean)true, (Writer)stringWriter);
            }
            catch (IOException e) {
                log.error("An exception occurred while trying to serialize the value: {}", (Throwable)e);
            }
        } else {
            stringWriter.write(ValueHelper.serialize((Value)value, (boolean)false));
        }
        return stringWriter.toString();
    }

    public static void addMixinsFromRepresentation(Node node, List<String> mixins) throws RepositoryException {
        for (String mixin : mixins) {
            if (!node.canAddMixin(mixin)) continue;
            node.addMixin(mixin);
        }
    }

    public static void addPropertiesFromRepresentation(Node node, List<JcrProperty> jcrProperties) throws RepositoryException {
        for (JcrProperty property : jcrProperties) {
            if (PROPERTY_BLACKLIST.containsValue(property.getName())) continue;
            JcrDataBindingHelper.addPropertyToNode(node, property);
        }
    }

    public static void addChildNodesFromRepresentation(Node node, List<JcrNode> nodes) throws RepositoryException {
        for (JcrNode jcrNode : nodes) {
            Node childNode = node.hasNode(jcrNode.getName()) && node.getNode(jcrNode.getName()).getDefinition().isAutoCreated() ? node.getNode(jcrNode.getName()) : node.addNode(jcrNode.getName(), jcrNode.getPrimaryType());
            JcrDataBindingHelper.addMixinsFromRepresentation(childNode, jcrNode.getMixinTypes());
            JcrDataBindingHelper.addPropertiesFromRepresentation(childNode, jcrNode.getProperties());
            if (jcrNode.getNodes().isEmpty()) continue;
            JcrDataBindingHelper.addChildNodesFromRepresentation(childNode, jcrNode.getNodes());
        }
    }

    public static void addPropertyToNode(Node node, JcrProperty property) throws RepositoryException {
        ValueFactory valueFactory = node.getSession().getValueFactory();
        if (property.isMultiple()) {
            Property existingProperty;
            String propName;
            Value[] values;
            if (property.getValues() != null) {
                values = new Value[property.getValues().size()];
                int propertyType = PropertyType.valueFromName((String)property.getType());
                int i = 0;
                for (String propertyValue : property.getValues()) {
                    if (propertyType == 2) {
                        values[i++] = ValueHelper.deserialize((String)propertyValue, (int)propertyType, (boolean)false, (ValueFactory)ValueFactoryImpl.getInstance());
                        continue;
                    }
                    values[i++] = ValueHelper.convert((String)propertyValue, (int)propertyType, (ValueFactory)valueFactory);
                }
            } else {
                values = new Value[]{};
            }
            if (node.hasProperty(propName = property.getName()) && !(existingProperty = node.getProperty(propName)).isMultiple()) {
                existingProperty.remove();
            }
            node.setProperty(property.getName(), values);
        } else {
            Property existingProperty;
            int propertyType = PropertyType.valueFromName((String)property.getType());
            String propertyValue = property.getValues().get(0);
            Value value = propertyType == 2 ? ValueHelper.deserialize((String)propertyValue, (int)propertyType, (boolean)false, (ValueFactory)ValueFactoryImpl.getInstance()) : ValueHelper.convert((String)propertyValue, (int)propertyType, (ValueFactory)valueFactory);
            String name = property.getName();
            if (node.hasProperty(name) && (existingProperty = node.getProperty(name)).isMultiple()) {
                existingProperty.remove();
            }
            node.setProperty(property.getName(), value);
        }
    }
}

