/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.exception;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.onehippo.forge.webservices.jaxrs.exception.ResponseExceptionRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class CustomWebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    public Response toResponse(WebApplicationException ex) {
        String message = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
        int status = ex.getResponse().getStatus();
        if (message == null) {
            message = ex.getCause() != null ? "cause is " + ex.getCause().getClass().getName() : "no cause is available";
        }
        message = this.deriveStatusMessage(message, status);
        ResponseExceptionRepresentation errorRepresentation = new ResponseExceptionRepresentation();
        errorRepresentation.setMessage(message);
        errorRepresentation.setStatusCode(status);
        return Response.status((int)status).entity((Object)errorRepresentation).type("application/json").build();
    }

    private String deriveStatusMessage(String message, int statusCode) {
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        if (status == null) {
            return message;
        }
        switch (status) {
            case BAD_REQUEST: 
            case NOT_FOUND: 
            case INTERNAL_SERVER_ERROR: 
            case NOT_ACCEPTABLE: 
            case UNAUTHORIZED: {
                return status.getReasonPhrase();
            }
        }
        return message;
    }
}

