/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.jcr;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.annotations.GZIP;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrNode;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrDataBindingHelper;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrSessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GZIP
@Api(value="v1/nodes", description="JCR node API", position=2)
@Path(value="v1/nodes")
@CrossOriginResourceSharing(allowAllOrigins=true)
public class NodesResource {
    private static final Logger log = LoggerFactory.getLogger(NodesResource.class);
    @Context
    private HttpServletRequest request;

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a node", notes="Returns a node from the specified path", position=1)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=JcrNode.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getNodeByPath(@ApiParam(value="Path of the node to retrieve", required=true) @PathParam(value="path") @DefaultValue(value="/") String path, @ApiParam(value="Depth of the retrieval", required=false) @QueryParam(value="depth") @DefaultValue(value="0") int depth, @Context UriInfo ui) throws RepositoryException {
        JcrNode jcrNode = null;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            String absolutePath = StringUtils.defaultIfEmpty((String)path, (String)"/");
            if (!absolutePath.startsWith("/")) {
                absolutePath = "/" + absolutePath;
            }
            if (!session.nodeExists(absolutePath)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Node node = session.getNode(absolutePath);
            jcrNode = JcrDataBindingHelper.getNodeRepresentation(node, depth);
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)jcrNode).build();
    }

    @POST
    @Path(value="{path:.*}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new sub node", notes="Adds a node and it's properties as a child of the provided location", position=2)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="Request not understood due to errors or malformed syntax"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=403, message="Access denied"), @ApiResponse(code=500, message="Error occurred")})
    public Response createNodeByPath(@ApiParam(required=true, value="Path of the node to which to add the new node e.g. '/content/documents/'") @PathParam(value="path") @DefaultValue(value="/") String parentPath, @Context UriInfo ui, JcrNode jcrNode) throws RepositoryException {
        URI newNodeUri = null;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            String absolutePath = StringUtils.defaultIfEmpty((String)parentPath, (String)"/");
            if (!absolutePath.startsWith("/")) {
                absolutePath = "/" + absolutePath;
            }
            if (!session.nodeExists(absolutePath)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isEmpty((String)jcrNode.getName())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isEmpty((String)jcrNode.getPrimaryType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Node parentNode = session.getNode(absolutePath);
            Node node = parentNode.addNode(jcrNode.getName(), jcrNode.getPrimaryType());
            JcrDataBindingHelper.addMixinsFromRepresentation(node, jcrNode.getMixinTypes());
            JcrDataBindingHelper.addPropertiesFromRepresentation(node, jcrNode.getProperties());
            JcrDataBindingHelper.addChildNodesFromRepresentation(node, jcrNode.getNodes());
            UriBuilder ub = ui.getAbsolutePathBuilder().path(this.getClass(), "getNodeByPath");
            newNodeUri = ub.build(new Object[]{node.getName()});
            session.save();
        }
        catch (Exception e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.created((URI)newNodeUri).build();
    }

    @PUT
    @Path(value="{path:.*}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update a node", notes="To update a node you need to provide the entire entity. The entity will be replaced with the  provided data. Be careful in case you want to update entire node structures, because the UUIDs will be  regenerated", position=3)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=204, message="Updated"), @ApiResponse(code=400, message="Request not understood due to errors or malformed syntax"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=403, message="Access denied"), @ApiResponse(code=500, message="Error occurred")})
    public Response updateNodeByPath(@ApiParam(required=true, value="Path of the node to update. '/content/documents/'") @PathParam(value="path") String parentPath, @Context UriInfo ui, JcrNode jcrNode) throws RepositoryException {
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            String absolutePath = StringUtils.defaultIfEmpty((String)parentPath, (String)"/");
            if (!absolutePath.startsWith("/")) {
                absolutePath = "/" + absolutePath;
            }
            if (StringUtils.isEmpty((String)jcrNode.getName())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isEmpty((String)jcrNode.getPrimaryType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!session.nodeExists(absolutePath)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Node nodeToUpdate = session.getNode(absolutePath);
            Node parentNode = nodeToUpdate.getParent();
            nodeToUpdate.remove();
            Node node = parentNode.addNode(jcrNode.getName(), jcrNode.getPrimaryType());
            JcrDataBindingHelper.addMixinsFromRepresentation(node, jcrNode.getMixinTypes());
            JcrDataBindingHelper.addPropertiesFromRepresentation(node, jcrNode.getProperties());
            JcrDataBindingHelper.addChildNodesFromRepresentation(node, jcrNode.getNodes());
            session.save();
        }
        catch (Exception e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{path:.*}")
    @ApiOperation(value="Delete a node", notes="Deletes a node (and child-nodes)", position=4)
    @ApiResponses(value={@ApiResponse(code=204, message="Deleted"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response deleteNodeByPath(@ApiParam(required=true, value="Path of the node to delete e.g. '/content/documents/'") @PathParam(value="path") String path) throws RepositoryException {
        try {
            String absolutePath = path;
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            if (StringUtils.isBlank((String)path)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!absolutePath.startsWith("/")) {
                absolutePath = "/" + absolutePath;
            }
            if (!session.nodeExists(absolutePath)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Node node = session.getNode(absolutePath);
            node.remove();
            session.save();
        }
        catch (Exception e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.noContent().build();
    }
}

