/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.jcr;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.hippoecm.repository.api.HippoNodeIterator;
import org.hippoecm.repository.util.RepoUtils;
import org.onehippo.forge.webservices.jaxrs.jcr.NodesResource;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrNode;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrQueryResult;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrQueryResultNode;
import org.onehippo.forge.webservices.jaxrs.jcr.model.JcrSearchQuery;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrDataBindingHelper;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrSessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="v1/_query", description="JCR QUERY API", position=4)
@Path(value="v1/_query")
@CrossOriginResourceSharing(allowAllOrigins=true)
public class QueryResource {
    private static final Logger log = LoggerFactory.getLogger(QueryResource.class);
    @Context
    private HttpServletRequest request;

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Query for nodes", notes="Returns a list of nodes", position=1)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=JcrQueryResult.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getResults(@ApiParam(required=true, value="JCR valid query syntax. '//element(*,hippo:document) order by @jcr:score descending'") @QueryParam(value="statement") String statement, @ApiParam(required=true, value="JCR query language e.g 'xpath, sql' or 'JCR-SQL2'") @QueryParam(value="language") String language, @ApiParam(required=false, value="Sets the maximum size of the result set.") @QueryParam(value="limit") @DefaultValue(value="200") int limit, @ApiParam(required=false, value="Sets the start offset of the result set.") @QueryParam(value="offset") int offset, @Context UriInfo ui) {
        JcrQueryResult jcrQueryResult = new JcrQueryResult();
        ArrayList<JcrQueryResultNode> resultItems = new ArrayList<JcrQueryResultNode>();
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query jcrQuery = "xpath".equals(language) ? queryManager.createQuery(RepoUtils.encodeXpath((String)statement), language) : queryManager.createQuery(statement, language);
            if (limit > 0) {
                jcrQuery.setLimit((long)limit);
            }
            if (offset > 0) {
                jcrQuery.setOffset((long)offset);
            }
            long start = System.currentTimeMillis();
            QueryResult queryResult = jcrQuery.execute();
            jcrQueryResult.setTook(System.currentTimeMillis() - start);
            RowIterator rowIterator = queryResult.getRows();
            HippoNodeIterator nodeIterator = (HippoNodeIterator)queryResult.getNodes();
            long totalSize = nodeIterator.getTotalSize();
            jcrQueryResult.setHits(totalSize);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.nextRow();
                JcrNode nodeRepresentation = JcrDataBindingHelper.getNodeRepresentation(row.getNode(), 0);
                URI nodeUri = this.getUriForNode(ui, nodeRepresentation);
                JcrQueryResultNode queryResultNode = new JcrQueryResultNode();
                for (String column : queryResult.getColumnNames()) {
                    Value value = row.getValue(column);
                    if (value == null) continue;
                    queryResultNode.addField(column, JcrDataBindingHelper.getPropertyValueAsString(value));
                }
                queryResultNode.setLink(nodeUri);
                queryResultNode.setScore(row.getScore());
                resultItems.add(queryResultNode);
            }
        }
        catch (RepositoryException e) {
            log.warn("An exception occurred while trying to perform query: {}", (Throwable)e);
            throw new WebApplicationException(e.getCause());
        }
        jcrQueryResult.setNodes(resultItems);
        return Response.ok((Object)jcrQueryResult).build();
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Query for nodes", notes="Returns a list of nodes. This method is especially useful when the query exceeds the maximum length of the URL.", position=2)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=JcrQueryResult.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getResults(JcrSearchQuery searchQuery, @Context UriInfo ui) {
        JcrQueryResult jcrQueryResult = new JcrQueryResult();
        ArrayList<JcrQueryResultNode> resultItems = new ArrayList<JcrQueryResultNode>();
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = "xpath".equals(searchQuery.getLanguage()) ? queryManager.createQuery(RepoUtils.encodeXpath((String)searchQuery.getStatement()), searchQuery.getLanguage()) : queryManager.createQuery(searchQuery.getStatement(), searchQuery.getLanguage());
            if (searchQuery.getLimit() > 0) {
                query.setLimit((long)searchQuery.getLimit());
            }
            if (searchQuery.getOffset() > 0) {
                query.setOffset((long)searchQuery.getOffset());
            }
            long start = System.currentTimeMillis();
            QueryResult queryResult = query.execute();
            jcrQueryResult.setTook(System.currentTimeMillis() - start);
            RowIterator rowIterator = queryResult.getRows();
            long totalSize = rowIterator.getSize();
            jcrQueryResult.setHits(totalSize);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.nextRow();
                JcrNode nodeRepresentation = JcrDataBindingHelper.getNodeRepresentation(row.getNode(), 0);
                URI nodeUri = this.getUriForNode(ui, nodeRepresentation);
                JcrQueryResultNode queryResultNode = new JcrQueryResultNode();
                for (String column : queryResult.getColumnNames()) {
                    Value value = row.getValue(column);
                    if (value == null) continue;
                    queryResultNode.addField(column, JcrDataBindingHelper.getPropertyValueAsString(value));
                }
                queryResultNode.setLink(nodeUri);
                queryResultNode.setScore(row.getScore());
                resultItems.add(queryResultNode);
            }
        }
        catch (RepositoryException e) {
            log.warn("An exception occurred while trying to perform query: {}", (Throwable)e);
        }
        jcrQueryResult.setNodes(resultItems);
        return Response.ok((Object)jcrQueryResult).build();
    }

    private URI getUriForNode(UriInfo ui, JcrNode nodeRepresentation) {
        UriBuilder uriBuilder = ui.getBaseUriBuilder().path(NodesResource.class).path(NodesResource.class, "getNodeByPath");
        return uriBuilder.build(new Object[]{nodeRepresentation.getPath().substring(1)});
    }
}

