/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.management;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.hippoecm.repository.PasswordHelper;
import org.hippoecm.repository.api.NodeNameCodec;
import org.onehippo.forge.webservices.jaxrs.exception.ResponseExceptionRepresentation;
import org.onehippo.forge.webservices.jaxrs.hateoas.Link;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrSessionUtil;
import org.onehippo.forge.webservices.jaxrs.management.model.Group;
import org.onehippo.forge.webservices.jaxrs.management.model.GroupCollection;
import org.onehippo.forge.webservices.jaxrs.management.model.User;
import org.onehippo.forge.webservices.jaxrs.management.model.UserCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Api(value="v1/users", description="Users API", position=6)
@Path(value="v1/users")
@CrossOriginResourceSharing(allowAllOrigins=true)
public class UsersResource {
    private static final Logger log = LoggerFactory.getLogger(UsersResource.class);
    private static final String NT_USER = "hipposys:user";
    public static final String PROP_FIRSTNAME = "hipposys:firstname";
    public static final String PROP_LASTNAME = "hipposys:lastname";
    public static final String PROP_EMAIL = "hipposys:email";
    public static final String PROP_SYSTEM = "hipposys:system";
    public static final String PROP_PASSWORD = "hipposys:password";
    public static final String PROP_PASSKEY = "hipposys:passkey";
    public static final String PROP_PROVIDER = "hipposys:securityprovider";
    public static final String PROP_PREVIOUSPASSWORDS = "hipposys:previouspasswords";
    public static final String PROP_PASSWORDLASTMODIFIED = "hipposys:passwordlastmodified";
    private static final String PROP_DESCRIPTION = "hipposys:description";
    private static final String QUERY_USER = "SELECT * FROM hipposys:user WHERE fn:name()='{}'";
    private static final String QUERY_USERS = "SELECT * FROM hipposys:user";
    private static final String QUERY_LOCAL_MEMBERSHIPS = "//element(*, hipposys:group)[@hipposys:members='{}']";
    private static final String QUERY_EXTERNAL_MEMBERSHIPS = "//element(*, hipposys:externalgroup)[@hipposys:members='{}']";
    @Context
    private HttpServletRequest request;

    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all users", notes="Returns a list of users", position=1)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=User.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getUsers(@Context UriInfo ui, @QueryParam(value="limit") @DefaultValue(value="20") long limit, @QueryParam(value="offset") @DefaultValue(value="0") long offset) throws RepositoryException {
        UserCollection users;
        try {
            ArrayList<User> userList = new ArrayList<User>();
            Query query = this.getQueryManager().createQuery(QUERY_USERS, "sql");
            query.setLimit(limit);
            query.setOffset(offset);
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                User userFromNode = this.createUserFromNode(node);
                UriBuilder ub = ui.getAbsolutePathBuilder().path(this.getClass(), "getUserByName");
                userFromNode.setHref(ub.build(new Object[]{userFromNode.getUsername()}).toString());
                userList.add(userFromNode);
            }
            users = new UserCollection(userList);
            UriBuilder ub = ui.getAbsolutePathBuilder().path(this.getClass(), "getUsers");
            ub.queryParam("offset", new Object[]{offset + limit});
            if (limit > 0L) {
                ub.queryParam("limit", new Object[]{limit});
            }
            URI nextUri = ub.build(new Object[0]);
            ub.replaceQueryParam("offset", new Object[]{0});
            ub.replaceQueryParam("limit", new Object[]{20});
            URI firstUri = ub.build(new Object[0]);
            if (offset > 0L) {
                ub.replaceQueryParam("offset", new Object[]{offset - limit});
                ub.replaceQueryParam("limit", new Object[]{limit});
                URI prevUri = ub.build(new Object[0]);
                users.addLink(new Link("prev", prevUri.toString()));
            }
            users.addLink(new Link("first", firstUri.toString()));
            users.addLink(new Link("next", nextUri.toString()));
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)users).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new user", notes="Adds a user", position=2)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="Request not understood due to errors or malformed syntax"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=403, message="Access denied"), @ApiResponse(code=500, message="Error occurred")})
    public Response createUser(@ApiParam(required=true, value="Username of the new user") User user, @Context UriInfo ui) throws RepositoryException {
        URI newUserUri;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            if (this.userExists(user.getUsername())) {
                ResponseExceptionRepresentation responseExceptionRepresentation = new ResponseExceptionRepresentation(Response.Status.CONFLICT.getStatusCode(), "User with name '" + user.getUsername() + "' already exists.");
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)responseExceptionRepresentation).build();
            }
            if (user.isExternal()) {
                ResponseExceptionRepresentation responseExceptionRepresentation = new ResponseExceptionRepresentation(Response.Status.CONFLICT.getStatusCode(), "External managed users can't be created through this interface.");
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)responseExceptionRepresentation).build();
            }
            Node node = this.create(user);
            UriBuilder ub = ui.getAbsolutePathBuilder().path(this.getClass(), "getUserByName");
            newUserUri = ub.build(new Object[]{node.getName()});
            session.save();
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.created((URI)newUserUri).build();
    }

    @GET
    @Path(value="/{username}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a user by username", notes="Returns a user by username", position=1)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=User.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getUserByName(@ApiParam(value="Name of the user to retrieve", required=true) @PathParam(value="username") String username, @Context UriInfo ui) throws RepositoryException {
        User user;
        try {
            Node userNode = this.getUserNodeByName(username);
            if (userNode == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            user = this.createUserFromNode(userNode);
            user.setGroups(this.getLocalMembershipsAsListOfGroups(user.getUsername()));
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)user).build();
    }

    @PUT
    @Path(value="/{username}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a user", notes="Updates a user by username", position=2)
    @ApiResponses(value={@ApiResponse(code=204, message="Updated"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response updateUserByName(@ApiParam(value="Name of the user to update", required=true) @PathParam(value="username") String username, @Context UriInfo ui, User user) throws RepositoryException {
        try {
            Node userNode = this.getUserNodeByName(username);
            if (userNode == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            this.updateUserNodeFromModel(userNode, user);
            userNode.getSession().save();
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)user).build();
    }

    @DELETE
    @Path(value="/{username}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a user by username", notes="Deletes a user by username", position=1)
    @ApiResponses(value={@ApiResponse(code=204, message="Deleted"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response deleteUserByName(@ApiParam(value="Username of the user to delete", required=true) @PathParam(value="username") String username, @Context UriInfo ui) throws RepositoryException {
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            Node userNode = this.getUserNodeByName(username);
            if (userNode == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            userNode.remove();
            session.save();
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/me")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the current user", notes="Returns the current user", position=5)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=User.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getCurrentUser(@Context UriInfo ui) throws RepositoryException {
        User user;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            Node userNode = this.getUserNodeByName(session.getUserID());
            if (userNode == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            user = this.createUserFromNode(userNode);
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)user).build();
    }

    @GET
    @Path(value="/{username}/groups")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the groups of a user", notes="Returns list of groups to which a user belongs", position=5)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getGroupsByUserName(@ApiParam(value="Name of the user for which to retrieve the groups", required=true) @PathParam(value="username") String username, @Context UriInfo ui) throws RepositoryException {
        List<Object> groups = new ArrayList();
        if (this.userExists(username)) {
            groups = this.getLocalMemberships(username);
        }
        GroupCollection collection = new GroupCollection(groups);
        return Response.ok((Object)collection).build();
    }

    private Node getUserNodeByName(String username) throws RepositoryException {
        Node userNode = null;
        String queryString = QUERY_USER.replace("{}", Text.escapeIllegalJcr10Chars((String)ISO9075.encode((String)NodeNameCodec.encode((String)username))));
        Query query = this.getQueryManager().createQuery(queryString, "sql");
        NodeIterator nodes = query.execute().getNodes();
        if (nodes.hasNext()) {
            userNode = nodes.nextNode();
        }
        return userNode;
    }

    private QueryManager getQueryManager() throws RepositoryException {
        Session session = JcrSessionUtil.getSessionFromRequest(this.request);
        return session.getWorkspace().getQueryManager();
    }

    private void updateUserNodeFromModel(Node userNode, User user) throws RepositoryException {
        userNode.setProperty("hipposys:active", user.isActive());
        userNode.setProperty(PROP_SYSTEM, user.isSystem());
        if (user.getEmail() != null) {
            userNode.setProperty(PROP_EMAIL, user.getEmail());
        }
        if (user.getFirstName() != null) {
            userNode.setProperty(PROP_FIRSTNAME, user.getFirstName());
        }
        if (user.getLastName() != null) {
            userNode.setProperty(PROP_LASTNAME, user.getLastName());
        }
        if (user.getPassword() != null && !userNode.getProperty(PROP_PASSWORD).equals(user.getPassword())) {
            this.savePassword(userNode, user.getPassword());
        }
    }

    public void savePassword(Node node, String password) throws RepositoryException {
        if (node.hasProperty(PROP_PASSWORD)) {
            Value[] newValues;
            String oldPassword = node.getProperty(PROP_PASSWORD).getString();
            if (node.hasProperty(PROP_PREVIOUSPASSWORDS)) {
                Value[] oldValues = node.getProperty(PROP_PREVIOUSPASSWORDS).getValues();
                newValues = new Value[oldValues.length + 1];
                System.arraycopy(oldValues, 0, newValues, 1, oldValues.length);
            } else {
                newValues = new Value[]{node.getSession().getValueFactory().createValue(oldPassword)};
            }
            node.setProperty(PROP_PREVIOUSPASSWORDS, newValues);
        }
        Calendar now = Calendar.getInstance();
        node.setProperty(PROP_PASSWORDLASTMODIFIED, now);
        node.setProperty(PROP_PASSWORD, UsersResource.createPasswordHash(password));
    }

    private User createUserFromNode(Node userNode) throws RepositoryException {
        User user = new User(NodeNameCodec.decode((String)userNode.getName()));
        user.setPath(userNode.getPath().substring(1));
        if (userNode.isNodeType("hipposys:externaluser")) {
            user.setExternal(true);
        }
        PropertyIterator pi = userNode.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            String name = p.getName();
            if (name.startsWith("jcr:")) continue;
            if (name.equals(PROP_EMAIL) || name.equalsIgnoreCase("email")) {
                user.setEmail(p.getString());
                continue;
            }
            if (name.equals(PROP_FIRSTNAME) || name.equalsIgnoreCase("firstname")) {
                user.setFirstName(p.getString());
                continue;
            }
            if (name.equals(PROP_LASTNAME) || name.equalsIgnoreCase("lastname")) {
                user.setLastName(p.getString());
                continue;
            }
            if (name.equals("hipposys:active")) {
                user.setActive(p.getBoolean());
                continue;
            }
            if (name.equals(PROP_PASSWORD) || name.equals(PROP_PASSKEY) || name.equals(PROP_PREVIOUSPASSWORDS) || name.equals(PROP_PROVIDER)) continue;
            if (name.equals(PROP_PASSWORDLASTMODIFIED)) {
                user.setPasswordLastModified(p.getDate());
                continue;
            }
            if (!name.equals(PROP_SYSTEM)) continue;
            user.setSystem(p.getBoolean());
        }
        return user;
    }

    public Node create(User user) throws RepositoryException {
        StringBuilder relPath = new StringBuilder();
        relPath.append("hippo:configuration");
        relPath.append("/");
        relPath.append("hippo:users");
        relPath.append("/");
        relPath.append(NodeNameCodec.encode((String)user.getUsername(), (boolean)true));
        Node node = JcrSessionUtil.getSessionFromRequest(this.request).getRootNode().addNode(relPath.toString(), NT_USER);
        this.setOrRemoveStringProperty(node, PROP_EMAIL, user.getEmail());
        this.setOrRemoveStringProperty(node, PROP_FIRSTNAME, user.getFirstName());
        this.setOrRemoveStringProperty(node, PROP_LASTNAME, user.getLastName());
        Calendar now = Calendar.getInstance();
        node.setProperty(PROP_PASSWORDLASTMODIFIED, now);
        node.setProperty(PROP_PASSWORD, UsersResource.createPasswordHash(user.getPassword()));
        return node;
    }

    public static String createPasswordHash(String password) throws RepositoryException {
        try {
            return PasswordHelper.getHash((char[])password.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException("Unable to hash password", (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("Unable to hash password", (Throwable)e);
        }
    }

    private void setOrRemoveStringProperty(Node node, String name, String value) throws RepositoryException {
        if (value == null && !node.hasProperty(name)) {
            return;
        }
        node.setProperty(name, value);
    }

    public boolean userExists(String username) {
        String queryString = QUERY_USER.replace("{}", Text.escapeIllegalJcr10Chars((String)ISO9075.encode((String)NodeNameCodec.encode((String)username))));
        try {
            Query query = this.getQueryManager().createQuery(queryString, "sql");
            return query.execute().getNodes().hasNext();
        }
        catch (RepositoryException e) {
            log.error("Unable to check if user '{}' exists, returning true", (Object)username, (Object)e);
            return true;
        }
    }

    public List<Group> getLocalMemberships(String username) {
        String escapedUsername = Text.escapeIllegalXpathSearchChars((String)username).replaceAll("'", "''");
        String queryString = QUERY_LOCAL_MEMBERSHIPS.replace("{}", escapedUsername);
        ArrayList<Group> localMemberships = new ArrayList<Group>();
        try {
            Query query = this.getQueryManager().createQuery(queryString, "xpath");
            NodeIterator iterator = query.execute().getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                if (node == null) continue;
                try {
                    Group g = new Group(node.getName());
                    if (node.hasProperty(PROP_DESCRIPTION)) {
                        g.setDescription(node.getProperty(PROP_DESCRIPTION).getString());
                    }
                    if (node.isNodeType("hipposys:externalgroup")) {
                        g.setExternal(true);
                    }
                    localMemberships.add(g);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to add group to local memberships for user '{}'", (Object)username, (Object)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Error while querying local memberships of user '{}'", (Throwable)e);
        }
        return localMemberships;
    }

    public List<Group> getLocalMembershipsAsListOfGroups(String username) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : this.getLocalMemberships(username)) {
            groups.add(group);
        }
        return groups;
    }
}

