/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.system;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="v1/_system", description="System API", position=6)
@Path(value="v1/_system")
@CrossOriginResourceSharing(allowAllOrigins=true)
public class SystemResource {
    private static final Logger log = LoggerFactory.getLogger(SystemResource.class);
    private static final double MB = 1048576.0;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest request;

    @ApiOperation(value="Display the system properties", notes="", position=1)
    @Path(value="/properties")
    @GET
    @Produces(value={"application/json"})
    public Response getSystemInfo() {
        Properties properties = System.getProperties();
        return Response.ok((Object)properties).build();
    }

    @ApiOperation(value="Display the version information", notes="", position=2)
    @Path(value="/versions")
    @GET
    @Produces(value={"application/json"})
    public Response getVersionInfo() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("Hippo Release Version", this.getHippoReleaseVersion());
        info.put("Project Version", this.getProjectVersion());
        return Response.ok(info).build();
    }

    @ApiOperation(value="Display the hardware information", notes="", position=3)
    @Path(value="/hardware")
    @GET
    @Produces(value={"application/json"})
    public Response getHardwareInfo() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        Runtime runtime = Runtime.getRuntime();
        info.put("OS architecture", System.getProperty("os.arch"));
        info.put("OS name", System.getProperty("os.name"));
        info.put("OS version", System.getProperty("os.version"));
        info.put("Processors", "# " + runtime.availableProcessors());
        return Response.ok(info).build();
    }

    @ApiOperation(value="Display the memory information from the JVM", notes="", position=4)
    @Path(value="/jvm")
    @GET
    @Produces(value={"application/json"})
    public Response getMemoryInfo() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        Runtime runtime = Runtime.getRuntime();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        info.put("Java vendor", System.getProperty("java.vendor"));
        info.put("Java version", System.getProperty("java.version"));
        info.put("Java VM", System.getProperty("java.vm.name"));
        info.put("Memory maximum", nf.format((double)runtime.maxMemory() / 1048576.0) + " MB");
        info.put("Memory taken", nf.format((double)runtime.totalMemory() / 1048576.0) + " MB");
        info.put("Memory free", nf.format((double)runtime.freeMemory() / 1048576.0) + " MB");
        info.put("Memory in use", nf.format((double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0) + " MB");
        info.put("Memory total free", nf.format((double)(runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory()) / 1048576.0) + " MB");
        return Response.ok(info).build();
    }

    private String getHippoReleaseVersion() {
        try {
            Manifest manifest = this.getWebAppManifest();
            if (manifest != null) {
                return manifest.getMainAttributes().getValue("Hippo-Release-Version");
            }
        }
        catch (IOException iOException) {
            log.debug("Error occurred getting the hippo cms release version from the webapp-manifest.", (Throwable)iOException);
        }
        return "unknown";
    }

    private String getProjectVersion() {
        try {
            Manifest manifest = this.getWebAppManifest();
            if (manifest != null) {
                return this.buildVersionString(manifest, "Project-Version", "Project-Build");
            }
        }
        catch (IOException iOException) {
            log.debug("Error occurred getting the project version from the webapp-manifest.", (Throwable)iOException);
        }
        return "unknown";
    }

    private Manifest getWebAppManifest() throws IOException {
        InputStream manifestInputStream = this.servletContext.getResourceAsStream("META-INF/MANIFEST.MF");
        if (manifestInputStream != null) {
            return new Manifest(manifestInputStream);
        }
        File manifestFile = new File(this.servletContext.getRealPath("/"), "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            return new Manifest(new FileInputStream(manifestFile));
        }
        return null;
    }

    private String buildVersionString(Manifest manifest, String versionAttribute, String buildAttribute) {
        String projectBuild;
        StringBuilder versionString = new StringBuilder();
        Attributes attributes = manifest.getMainAttributes();
        String projectVersion = attributes.getValue(versionAttribute);
        if (projectVersion != null) {
            versionString.append(projectVersion);
        }
        if ((projectBuild = attributes.getValue(buildAttribute)) != null && !"-1".equals(projectBuild)) {
            if (versionString.length() > 0) {
                versionString.append(", build: ");
            }
            versionString.append(projectBuild);
        }
        return versionString.toString();
    }
}

