/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices;

import javax.jcr.LoginException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;
import org.onehippo.forge.webservices.jaxrs.exception.UnauthorizedException;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrSessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class HippoAuthenticationRequestHandler
implements RequestHandler,
ResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(HippoAuthenticationRequestHandler.class);
    private Session session = null;

    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        AuthorizationPolicy policy = (AuthorizationPolicy)m.get(AuthorizationPolicy.class);
        if (policy != null) {
            String username = policy.getUserName();
            String password = policy.getPassword();
            try {
                this.session = JcrSessionUtil.createSession(username, password);
                if (this.isAuthenticated(this.session)) {
                    HttpServletRequest request = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
                    request.setAttribute("HIPPO.SESSION", (Object)this.session);
                    return null;
                }
                throw new UnauthorizedException();
            }
            catch (LoginException e) {
                log.debug("Login failed: {}", (Throwable)e);
                throw new UnauthorizedException(e.getMessage());
            }
        }
        throw new UnauthorizedException();
    }

    public Response handleResponse(Message m, OperationResourceInfo ori, Response response) {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
            this.session = null;
        }
        return null;
    }

    private boolean isAuthenticated(Session session) {
        return session != null;
    }
}

