/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.lang.reflect.Field;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.jackrabbit.api.stats.QueryStat;
import org.apache.jackrabbit.api.stats.QueryStatDto;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.stats.QueryStatCore;
import org.apache.jackrabbit.core.stats.RepositoryStatisticsImpl;
import org.hippoecm.repository.impl.RepositoryDecorator;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrSessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="_stats", description="Statistics API.", position=5)
@Path(value="_stats")
@CrossOriginResourceSharing(allowAllOrigins=true)
public class StatsResource {
    @Context
    private HttpServletRequest request;
    private RepositoryStatisticsImpl statistics;
    private static final Logger log = LoggerFactory.getLogger(StatsResource.class);

    @ApiOperation(value="Display all statistics about the repository instance; nr of sessions, queries, bundle operations", notes="", position=1)
    @GET
    @Path(value="/repository")
    @Produces(value={"application/json"})
    public Response getInstanceInformation() {
        Session session = JcrSessionUtil.getSessionFromRequest(this.request);
        RepositoryStatistics repositoryStatistics = this.getRepositoryStatistics(session);
        return Response.ok((Object)repositoryStatistics).build();
    }

    @ApiOperation(value="Display specific statistics based on the key about the repository instance", notes="", position=2)
    @GET
    @Path(value="/repository/type/{key}")
    @Produces(value={"application/json"})
    public Response getInstanceInformationByKey(@PathParam(value="key") String key) {
        TimeSeries timeSeries = null;
        Session session = JcrSessionUtil.getSessionFromRequest(this.request);
        RepositoryStatistics repositoryStatistics = this.getRepositoryStatistics(session);
        timeSeries = repositoryStatistics.getTimeSeries(RepositoryStatistics.Type.getType((String)key));
        return Response.ok((Object)timeSeries).build();
    }

    @ApiOperation(value="Displays the most popular queries", notes="Query stats collection needs to be enabled", position=3)
    @GET
    @Path(value="/queries/popular")
    @Produces(value={"application/json"})
    public Response getPopularQueries() {
        QueryStatDto[] popularQueries = null;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            QueryStat queryStatistics = this.getQueryStatistics(session);
            popularQueries = queryStatistics.getPopularQueries();
        }
        catch (IllegalAccessException e) {
            log.warn("An exception occurred while trying to get query information: {}", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            log.warn("An exception occurred while trying to get query information: {}", (Throwable)e);
        }
        return Response.ok(popularQueries).build();
    }

    @ApiOperation(value="Displays the slowest queries", notes="Query stats collection needs to be enabled", position=4)
    @GET
    @Path(value="/queries/slow")
    @Produces(value={"application/json"})
    public Response getSlowQueries() {
        QueryStatDto[] slowQueries = null;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            QueryStat queryStatistics = this.getQueryStatistics(session);
            slowQueries = queryStatistics.getSlowQueries();
        }
        catch (IllegalAccessException e) {
            log.warn("An exception occurred while trying to get query information: {}", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            log.warn("An exception occurred while trying to get query information: {}", (Throwable)e);
        }
        return Response.ok(slowQueries).build();
    }

    private QueryStat getQueryStatistics(Session session) throws NoSuchFieldException, IllegalAccessException {
        RepositoryContext repositoryContext = this.getRepositoryContext(session);
        QueryStatCore queryStat = repositoryContext.getStatManager().getQueryStat();
        return queryStat;
    }

    private RepositoryStatistics getRepositoryStatistics(Session session) {
        if (this.statistics == null) {
            try {
                RepositoryContext repositoryContext = this.getRepositoryContext(session);
                this.statistics = repositoryContext.getRepositoryStatistics();
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException(e);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            return this.statistics;
        }
        return this.statistics;
    }

    private RepositoryContext getRepositoryContext(Session session) throws NoSuchFieldException, IllegalAccessException {
        Field contextField = RepositoryImpl.class.getDeclaredField("context");
        if (!contextField.isAccessible()) {
            contextField.setAccessible(true);
        }
        return (RepositoryContext)contextField.get(RepositoryDecorator.unwrap((Repository)session.getRepository()));
    }
}

