/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.jcr.util;

import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.hippoecm.repository.HippoRepository;
import org.hippoecm.repository.HippoRepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrSessionUtil {
    private static final Logger log = LoggerFactory.getLogger(JcrSessionUtil.class);

    private JcrSessionUtil() {
    }

    public static Session getSessionFromRequest(HttpServletRequest request) {
        return (Session)request.getAttribute("HIPPO.SESSION");
    }

    public static Session createSession(String username, String password) throws LoginException {
        Session session = null;
        try {
            HippoRepository repository = HippoRepositoryFactory.getHippoRepository();
            session = repository.login(username, password.toCharArray());
        }
        catch (LoginException le) {
            throw new LoginException((Throwable)le);
        }
        catch (RepositoryException e) {
            log.error("An exception occurred: {}", (Throwable)e);
        }
        return session;
    }
}

