/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.forge.webservices.jaxrs.management;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.hippoecm.repository.api.NodeNameCodec;
import org.onehippo.forge.webservices.jaxrs.exception.ResponseExceptionRepresentation;
import org.onehippo.forge.webservices.jaxrs.hateoas.Link;
import org.onehippo.forge.webservices.jaxrs.jcr.util.JcrSessionUtil;
import org.onehippo.forge.webservices.jaxrs.management.model.Group;
import org.onehippo.forge.webservices.jaxrs.management.model.GroupCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="groups", description="Groups API", position=6)
@Path(value="/groups")
public class GroupsResource {
    private static final Logger log = LoggerFactory.getLogger(GroupsResource.class);
    private static final String PROP_DESCRIPTION = "hipposys:description";
    private static final String PROP_MEMBERS = "hipposys:members";
    private static final String QUERY_ALL = "select * from hipposys:group";
    private static final String QUERY_GROUP = "SELECT * FROM hipposys:group WHERE fn:name()='{}'";
    @Context
    private HttpServletRequest request;

    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all groups", notes="Returns a list of groups", position=1)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=GroupCollection.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getGroups(@Context UriInfo ui, @QueryParam(value="limit") @DefaultValue(value="20") long limit, @QueryParam(value="offset") @DefaultValue(value="0") long offset) throws RepositoryException {
        GroupCollection groups;
        try {
            ArrayList<Group> groupList = new ArrayList<Group>();
            Query query = this.getQueryManager().createQuery(QUERY_ALL, "sql");
            query.setLimit(limit);
            query.setOffset(offset);
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                Group groupFromNode = this.getGroupFromNode(node);
                UriBuilder ub = ui.getAbsolutePathBuilder().path(this.getClass(), "getGroupByName");
                groupFromNode.setHref(ub.build(new Object[]{groupFromNode.getName()}).toString());
                groupList.add(groupFromNode);
            }
            groups = new GroupCollection(groupList);
            UriBuilder ub = ui.getAbsolutePathBuilder().path(this.getClass(), "getGroups");
            ub.queryParam("offset", new Object[]{offset + limit});
            if (limit > 0L) {
                ub.queryParam("limit", new Object[]{limit});
            }
            URI nextUri = ub.build(new Object[0]);
            ub.replaceQueryParam("offset", new Object[]{0});
            ub.replaceQueryParam("limit", new Object[]{20});
            URI firstUri = ub.build(new Object[0]);
            if (offset > 0L) {
                ub.replaceQueryParam("offset", new Object[]{offset - limit});
                ub.replaceQueryParam("limit", new Object[]{limit});
                URI prevUri = ub.build(new Object[0]);
                groups.addLink(new Link("prev", prevUri.toString()));
            }
            groups.addLink(new Link("first", firstUri.toString()));
            groups.addLink(new Link("next", nextUri.toString()));
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)groups).build();
    }

    @GET
    @Path(value="/{groupName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a group by it's name", notes="Returns a group by it's name", position=1)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Group.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response getGroupByName(@ApiParam(value="Name of the group to retrieve", required=true) @PathParam(value="groupName") String groupName, @Context UriInfo ui) throws RepositoryException {
        Node groupNodeByName = this.getGroupNodeByName(groupName);
        if (groupNodeByName == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Group group = this.getGroupFromNode(groupNodeByName);
        return Response.ok((Object)group).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new group", notes="Adds a new group", position=2)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=201, message="Created"), @ApiResponse(code=400, message="Request not understood due to errors or malformed syntax"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=403, message="Access denied"), @ApiResponse(code=500, message="Error occurred")})
    public Response createGroup(@ApiParam(required=true, value="Name of the new group") Group group, @Context UriInfo ui) throws RepositoryException {
        URI newUserUri;
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            if (this.exists(group.getName())) {
                ResponseExceptionRepresentation responseExceptionRepresentation = new ResponseExceptionRepresentation(Response.Status.CONFLICT.getStatusCode(), "Group with name '" + group.getName() + "' already exists.");
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)responseExceptionRepresentation).build();
            }
            if (group.isExternal()) {
                ResponseExceptionRepresentation responseExceptionRepresentation = new ResponseExceptionRepresentation(Response.Status.CONFLICT.getStatusCode(), "External managed group can't be created through this interface.");
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)responseExceptionRepresentation).build();
            }
            Node node = this.create(group);
            UriBuilder ub = ui.getAbsolutePathBuilder().path(this.getClass(), "getGroupByName");
            newUserUri = ub.build(new Object[]{node.getName()});
            session.save();
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.created((URI)newUserUri).build();
    }

    @PUT
    @Path(value="/{groupName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Updates a new group", notes="Updates a new group", position=3)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=204, message="Updated"), @ApiResponse(code=400, message="Request not understood due to errors or malformed syntax"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=403, message="Access denied"), @ApiResponse(code=500, message="Error occurred")})
    public Response updateGroup(@ApiParam(required=true, value="Name of the group") Group group, @Context UriInfo ui) throws RepositoryException {
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            if (!this.exists(group.getName())) {
                ResponseExceptionRepresentation responseExceptionRepresentation = new ResponseExceptionRepresentation(Response.Status.CONFLICT.getStatusCode(), "Group with name '" + group.getName() + "' does not exists.");
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)responseExceptionRepresentation).build();
            }
            if (group.isExternal()) {
                ResponseExceptionRepresentation responseExceptionRepresentation = new ResponseExceptionRepresentation(Response.Status.CONFLICT.getStatusCode(), "External managed group can't be updated through this interface.");
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)responseExceptionRepresentation).build();
            }
            this.update(group);
            session.save();
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{groupName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a group by it's name", notes="Deletes a group by name", position=1)
    @ApiResponses(value={@ApiResponse(code=204, message="Deleted"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Node not found"), @ApiResponse(code=500, message="Error occurred")})
    public Response deleteGroupByName(@ApiParam(value="Name of the group to delete", required=true) @PathParam(value="groupName") String groupName, @Context UriInfo ui) throws RepositoryException {
        try {
            Session session = JcrSessionUtil.getSessionFromRequest(this.request);
            Node groupNode = this.getGroupNodeByName(groupName);
            if (groupNode == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            groupNode.remove();
            session.save();
        }
        catch (RepositoryException e) {
            log.error("Error: {}", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.noContent().build();
    }

    public boolean exists(String groupname) {
        return this.getGroupNodeByName(groupname) != null;
    }

    public Node getGroupNodeByName(String groupName) {
        String escapedGroupName = Text.escapeIllegalJcr10Chars((String)ISO9075.encode((String)NodeNameCodec.encode((String)groupName, (boolean)true)));
        String queryString = QUERY_GROUP.replace("{}", escapedGroupName);
        try {
            Query query = this.getQueryManager().createQuery(queryString, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            if (!iterator.hasNext()) {
                return null;
            }
            Node node = iterator.nextNode();
            return node;
        }
        catch (RepositoryException e) {
            log.error("Unable to check if group '{}' exists, returning true", (Object)groupName, (Object)e);
            return null;
        }
    }

    private Group getGroupFromNode(Node node) throws RepositoryException {
        Group group = new Group();
        group.setName(NodeNameCodec.decode((String)node.getName()));
        if (node.hasProperty(PROP_DESCRIPTION)) {
            group.setDescription(node.getProperty(PROP_DESCRIPTION).getString());
        }
        if (node.isNodeType("hipposys:externalgroup")) {
            group.setExternal(true);
        }
        if (node.hasProperty(PROP_MEMBERS)) {
            Value[] values = node.getProperty(PROP_MEMBERS).getValues();
            ArrayList<String> members = new ArrayList<String>();
            for (Value value : values) {
                members.add(value.getString());
            }
            group.setMembers(members);
        }
        return group;
    }

    public Node create(Group group) throws RepositoryException {
        if (this.exists(group.getName())) {
            throw new RepositoryException("Group already exists");
        }
        StringBuilder relPath = new StringBuilder();
        relPath.append("hippo:configuration");
        relPath.append("/");
        relPath.append("hippo:groups");
        relPath.append("/");
        relPath.append(NodeNameCodec.encode((String)group.getName(), (boolean)true));
        Node node = JcrSessionUtil.getSessionFromRequest(this.request).getRootNode().addNode(relPath.toString(), "hipposys:group");
        this.setOrRemoveStringProperty(node, PROP_DESCRIPTION, group.getDescription());
        List<String> members = group.getMembers();
        if (members != null) {
            this.setOrRemoveMultiStringProperty(node, PROP_MEMBERS, members.toArray(new String[0]));
        }
        node.getParent().getSession().save();
        return node;
    }

    public Node update(Group group) throws RepositoryException {
        if (!this.exists(group.getName())) {
            throw new RepositoryException("Group does not exists");
        }
        StringBuilder relPath = new StringBuilder();
        relPath.append("hippo:configuration");
        relPath.append("/");
        relPath.append("hippo:groups");
        relPath.append("/");
        relPath.append(NodeNameCodec.encode((String)group.getName(), (boolean)true));
        Node node = JcrSessionUtil.getSessionFromRequest(this.request).getRootNode().getNode(relPath.toString());
        this.setOrRemoveStringProperty(node, PROP_DESCRIPTION, group.getDescription());
        List<String> members = group.getMembers();
        if (members != null) {
            this.setOrRemoveMultiStringProperty(node, PROP_MEMBERS, members.toArray(new String[0]));
        }
        return node;
    }

    private void setOrRemoveStringProperty(Node node, String name, String value) throws RepositoryException {
        if (value == null && !node.hasProperty(name)) {
            return;
        }
        node.setProperty(name, value);
    }

    private void setOrRemoveMultiStringProperty(Node node, String name, String[] values) throws RepositoryException {
        if (values == null && !node.hasProperty(name)) {
            return;
        }
        node.setProperty(name, values);
    }

    public QueryManager getQueryManager() throws RepositoryException {
        return JcrSessionUtil.getSessionFromRequest(this.request).getWorkspace().getQueryManager();
    }
}

