/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.atomic.internal;

import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.atomic.AsyncAtomicReference;
import net.kuujo.copycat.atomic.AsyncAtomicReferenceProxy;
import net.kuujo.copycat.atomic.internal.AtomicReferenceState;
import net.kuujo.copycat.atomic.internal.DefaultAtomicReferenceState;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceContext;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.internal.DefaultStateMachine;

public class DefaultAsyncAtomicReference<T>
extends AbstractResource<AsyncAtomicReference<T>>
implements AsyncAtomicReference<T> {
    private StateMachine<AtomicReferenceState<T>> stateMachine;
    private AsyncAtomicReferenceProxy<T> proxy;

    public DefaultAsyncAtomicReference(ResourceContext context) {
        super(context);
        this.stateMachine = new DefaultStateMachine(context, AtomicReferenceState.class, DefaultAtomicReferenceState.class);
    }

    @Override
    public CompletableFuture<T> get() {
        return this.proxy.get();
    }

    @Override
    public CompletableFuture<Void> set(T value) {
        return this.proxy.set(value);
    }

    @Override
    public CompletableFuture<T> getAndSet(T value) {
        return this.proxy.getAndSet(value);
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(T expect, T update) {
        return this.proxy.compareAndSet(expect, update);
    }

    public synchronized CompletableFuture<AsyncAtomicReference<T>> open() {
        return ((CompletableFuture)((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.stateMachine.open())).thenRun(() -> {
            this.proxy = (AsyncAtomicReferenceProxy)this.stateMachine.createProxy(AsyncAtomicReferenceProxy.class);
        })).thenApply(v -> this);
    }

    public synchronized CompletableFuture<Void> close() {
        this.proxy = null;
        return this.stateMachine.close().thenCompose(v -> this.runShutdownTasks());
    }
}

