/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections;

import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.util.internal.Assert;

public abstract class AsyncCollectionConfig<T extends AsyncCollectionConfig<T>>
extends ResourceConfig<T> {
    private static final String ASYNC_COLLECTION_CONSISTENCY = "consistency";
    private static final String CONFIGURATION = "collection";
    private static final String DEFAULT_CONFIGURATION = "collection-defaults";

    protected AsyncCollectionConfig(Map<String, Object> config, String ... resources) {
        super(config, AsyncCollectionConfig.addResources((String[])resources, (String[])new String[]{CONFIGURATION, DEFAULT_CONFIGURATION}));
    }

    protected AsyncCollectionConfig(String ... resources) {
        super(AsyncCollectionConfig.addResources((String[])resources, (String[])new String[]{CONFIGURATION, DEFAULT_CONFIGURATION}));
    }

    protected AsyncCollectionConfig(T config) {
        super(config);
    }

    public void setConsistency(String consistency) {
        this.config = this.config.withValue(ASYNC_COLLECTION_CONSISTENCY, ConfigValueFactory.fromAnyRef((Object)Consistency.parse((String)((String)Assert.isNotNull((Object)consistency, (String)ASYNC_COLLECTION_CONSISTENCY))).toString()));
    }

    public void setConsistency(Consistency consistency) {
        this.config = this.config.withValue(ASYNC_COLLECTION_CONSISTENCY, ConfigValueFactory.fromAnyRef((Object)((Consistency)Assert.isNotNull((Object)consistency, (String)ASYNC_COLLECTION_CONSISTENCY)).toString()));
    }

    public Consistency getConsistency() {
        return Consistency.parse((String)this.config.getString(ASYNC_COLLECTION_CONSISTENCY));
    }

    public T withConsistency(String consistency) {
        this.setConsistency(consistency);
        return (T)((Object)this);
    }

    public T withConsistency(Consistency consistency) {
        this.setConsistency(consistency);
        return (T)((Object)this);
    }
}

