/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections;

import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.collections.internal.lock.DefaultAsyncLock;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.state.StateLogConfig;
import net.kuujo.copycat.util.internal.Assert;

public class AsyncLockConfig
extends ResourceConfig<AsyncLockConfig> {
    private static final String DEFAULT_CONFIGURATION = "lock-defaults";
    private static final String CONFIGURATION = "lock";

    public AsyncLockConfig() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public AsyncLockConfig(Map<String, Object> config) {
        super(config, new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public AsyncLockConfig(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    protected AsyncLockConfig(AsyncLockConfig config) {
        super((ResourceConfig)config);
    }

    public AsyncLockConfig copy() {
        return new AsyncLockConfig(this);
    }

    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config((Object)this.getReplicas(), (this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()) ? 1 : 0) != 0, (String)"Resource replica set must contain only active cluster members", (Object[])new Object[0]);
        return new StateLogConfig(this.toMap()).resolve(cluster).withResourceType(DefaultAsyncLock.class);
    }
}

