/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections.internal.collection;

import java.util.Collection;
import java.util.Iterator;
import net.kuujo.copycat.collections.internal.collection.CollectionState;
import net.kuujo.copycat.state.Initializer;
import net.kuujo.copycat.state.StateContext;

public abstract class AbstractCollectionState<T extends CollectionState<T, V>, U extends Collection<V>, V>
implements CollectionState<T, V> {
    protected U collection;

    protected abstract U createCollection();

    @Override
    @Initializer
    public void init(StateContext<T> context) {
        this.collection = (Collection)context.get("value");
        if (this.collection == null) {
            this.collection = this.createCollection();
            context.put("value", this.collection);
        }
    }

    @Override
    public boolean add(V value) {
        return this.collection.add(value);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.collection.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.collection.retainAll(c);
    }

    @Override
    public boolean remove(Object value) {
        return this.collection.remove(value);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.collection.removeAll(c);
    }

    @Override
    public boolean contains(Object value) {
        return this.collection.contains(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public Iterator<V> iterator() {
        throw new UnsupportedOperationException("Cannot iterate collection state");
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.collection.toArray(a);
    }
}

