/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections.internal.lock;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.kuujo.copycat.collections.AsyncLock;
import net.kuujo.copycat.collections.internal.lock.AsyncLockProxy;
import net.kuujo.copycat.collections.internal.lock.LockState;
import net.kuujo.copycat.collections.internal.lock.UnlockedLockState;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceContext;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.internal.DefaultStateMachine;
import net.kuujo.copycat.util.concurrent.Futures;

public class DefaultAsyncLock
extends AbstractResource<AsyncLock>
implements AsyncLock {
    private final StateMachine<LockState> stateMachine;
    private AsyncLockProxy proxy;

    public DefaultAsyncLock(ResourceContext context) {
        super(context);
        this.stateMachine = new DefaultStateMachine(context, LockState.class, UnlockedLockState.class);
    }

    protected <T> CompletableFuture<T> checkOpen(Supplier<CompletableFuture<T>> supplier) {
        if (this.proxy == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Lock closed"));
        }
        return supplier.get();
    }

    @Override
    public CompletableFuture<Boolean> lock() {
        return this.checkOpen(() -> this.proxy.lock(this.cluster().member().uri(), Thread.currentThread().getId()));
    }

    @Override
    public CompletableFuture<Void> unlock() {
        return this.checkOpen(() -> this.proxy.unlock(this.cluster().member().uri(), Thread.currentThread().getId()));
    }

    public synchronized CompletableFuture<AsyncLock> open() {
        return ((CompletableFuture)((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.stateMachine.open())).thenRun(() -> {
            this.proxy = (AsyncLockProxy)this.stateMachine.createProxy(AsyncLockProxy.class);
        })).thenApply(v -> this);
    }

    public synchronized CompletableFuture<Void> close() {
        this.proxy = null;
        return this.stateMachine.close().thenCompose(v -> this.runShutdownTasks());
    }
}

