/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections.internal.lock;

import net.kuujo.copycat.cluster.MembershipEvent;
import net.kuujo.copycat.collections.internal.lock.LockState;
import net.kuujo.copycat.collections.internal.lock.UnlockedLockState;
import net.kuujo.copycat.state.Initializer;
import net.kuujo.copycat.state.StateContext;

public class LockedLockState
implements LockState {
    private StateContext<LockState> context;

    @Override
    @Initializer
    public void init(StateContext<LockState> context) {
        this.context = context;
        String currentMember = (String)context.get("member");
        if (currentMember == null || context.cluster().member(currentMember) == null) {
            context.transition((Object)new UnlockedLockState());
        } else {
            context.cluster().addMembershipListener(this::handleMembershipEvent);
        }
    }

    private void handleMembershipEvent(MembershipEvent event) {
        if (event.type() == MembershipEvent.Type.LEAVE) {
            String currentMember = (String)this.context.get("member");
            if (event.member().uri().equals(currentMember)) {
                this.context.remove("member");
                this.context.remove("thread");
                this.context.transition((Object)new UnlockedLockState());
            }
        }
    }

    @Override
    public boolean lock(String member, long thread) {
        return false;
    }

    @Override
    public void unlock(String member, long thread) {
        String currentMember = (String)this.context.get("member");
        Long currentThread = (Long)this.context.get("thread");
        if (currentMember != null && !currentMember.equals(member) || currentThread != null && !currentThread.equals(thread)) {
            throw new IllegalStateException("Lock is owned by another thread");
        }
        this.context.remove("member");
        this.context.remove("thread");
        this.context.cluster().removeMembershipListener(this::handleMembershipEvent);
        this.context.transition((Object)new UnlockedLockState());
    }
}

