/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections;

import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.collections.internal.map.DefaultAsyncMap;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.state.StateLogConfig;
import net.kuujo.copycat.util.internal.Assert;

public class AsyncMapConfig
extends ResourceConfig<AsyncMapConfig> {
    private static final String ASYNC_MAP_CONSISTENCY = "consistency";
    private static final String DEFAULT_CONFIGURATION = "map-defaults";
    private static final String CONFIGURATION = "map";

    public AsyncMapConfig() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public AsyncMapConfig(Map<String, Object> config) {
        super(config, new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public AsyncMapConfig(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    protected AsyncMapConfig(AsyncMapConfig config) {
        super((ResourceConfig)config);
    }

    public AsyncMapConfig copy() {
        return new AsyncMapConfig(this);
    }

    public void setConsistency(String consistency) {
        this.config = this.config.withValue(ASYNC_MAP_CONSISTENCY, ConfigValueFactory.fromAnyRef((Object)Consistency.parse((String)((String)Assert.isNotNull((Object)consistency, (String)ASYNC_MAP_CONSISTENCY))).toString()));
    }

    public void setConsistency(Consistency consistency) {
        this.config = this.config.withValue(ASYNC_MAP_CONSISTENCY, ConfigValueFactory.fromAnyRef((Object)((Consistency)Assert.isNotNull((Object)consistency, (String)ASYNC_MAP_CONSISTENCY)).toString()));
    }

    public Consistency getConsistency() {
        return Consistency.parse((String)this.config.getString(ASYNC_MAP_CONSISTENCY));
    }

    public AsyncMapConfig withConsistency(String consistency) {
        this.setConsistency(consistency);
        return this;
    }

    public AsyncMapConfig withConsistency(Consistency consistency) {
        this.setConsistency(consistency);
        return this;
    }

    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config((Object)this.getReplicas(), (this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()) ? 1 : 0) != 0, (String)"Resource replica set must contain only active cluster members", (Object[])new Object[0]);
        return new StateLogConfig(this.toMap()).resolve(cluster).withResourceType(DefaultAsyncMap.class);
    }
}

