/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections.internal.collection;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.kuujo.copycat.collections.AsyncCollection;
import net.kuujo.copycat.collections.AsyncCollectionProxy;
import net.kuujo.copycat.collections.internal.collection.CollectionState;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceManager;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.util.concurrent.Futures;

public abstract class AbstractAsyncCollection<S extends AsyncCollection<S, V>, T extends CollectionState<T, V>, U extends AsyncCollectionProxy<V>, V>
extends AbstractResource<S>
implements AsyncCollection<S, V> {
    private final StateMachine<T> stateMachine;
    private final Class<U> proxyClass;
    protected U proxy;

    protected AbstractAsyncCollection(ResourceManager context, StateMachine<T> stateMachine, Class proxyClass) {
        super(context);
        this.stateMachine = stateMachine;
        this.proxyClass = proxyClass;
    }

    protected <R> CompletableFuture<R> checkOpen(Supplier<CompletableFuture<R>> supplier) {
        if (this.proxy == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Collection closed"));
        }
        return supplier.get();
    }

    @Override
    public CompletableFuture<Boolean> add(V value) {
        return this.checkOpen(() -> this.proxy.add((Object)value));
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends V> values) {
        return this.checkOpen(() -> this.proxy.addAll(values));
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<?> values) {
        return this.checkOpen(() -> this.proxy.retainAll(values));
    }

    @Override
    public CompletableFuture<Boolean> remove(Object value) {
        return this.checkOpen(() -> this.proxy.remove(value));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<?> values) {
        return this.checkOpen(() -> this.proxy.removeAll(values));
    }

    @Override
    public CompletableFuture<Boolean> contains(Object value) {
        return this.checkOpen(() -> this.proxy.contains(value));
    }

    @Override
    public CompletableFuture<Boolean> containsAll(Collection<?> values) {
        return this.checkOpen(() -> this.proxy.containsAll(values));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.checkOpen(() -> this.proxy.size());
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.checkOpen(() -> this.proxy.isEmpty());
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.checkOpen(() -> this.proxy.clear());
    }

    public synchronized CompletableFuture<S> open() {
        return ((CompletableFuture)((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.stateMachine.open())).thenRun(() -> {
            this.proxy = (AsyncCollectionProxy)this.stateMachine.createProxy(this.proxyClass);
        })).thenApply(v -> this);
    }

    public synchronized CompletableFuture<Void> close() {
        this.proxy = null;
        return this.stateMachine.close().thenCompose(v -> this.runShutdownTasks());
    }
}

