/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections.internal.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.kuujo.copycat.collections.AsyncMultiMap;
import net.kuujo.copycat.collections.AsyncMultiMapProxy;
import net.kuujo.copycat.collections.internal.map.DefaultMultiMapState;
import net.kuujo.copycat.collections.internal.map.MultiMapState;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceManager;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.internal.DefaultStateMachine;
import net.kuujo.copycat.util.concurrent.Futures;

public class DefaultAsyncMultiMap<K, V>
extends AbstractResource<AsyncMultiMap<K, V>>
implements AsyncMultiMap<K, V> {
    private final StateMachine<MultiMapState<K, V>> stateMachine;
    private AsyncMultiMapProxy<K, V> proxy;

    public DefaultAsyncMultiMap(ResourceManager context) {
        super(context);
        this.stateMachine = new DefaultStateMachine(context, MultiMapState.class, DefaultMultiMapState.class);
    }

    protected <T> CompletableFuture<T> checkOpen(Supplier<CompletableFuture<T>> supplier) {
        if (this.proxy == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Map closed"));
        }
        return supplier.get();
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.checkOpen(this.proxy::size);
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.checkOpen(this.proxy::isEmpty);
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.checkOpen(() -> this.proxy.containsKey(key));
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V value) {
        return this.checkOpen(() -> this.proxy.containsValue(value));
    }

    @Override
    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return this.checkOpen(() -> this.proxy.containsEntry(key, value));
    }

    @Override
    public CompletableFuture<Collection<V>> get(K key) {
        return this.checkOpen(() -> this.proxy.get(key));
    }

    @Override
    public CompletableFuture<Collection<V>> put(K key, V value) {
        return this.checkOpen(() -> this.proxy.put(key, value));
    }

    @Override
    public CompletableFuture<Collection<V>> remove(K key) {
        return this.checkOpen(() -> this.proxy.remove(key));
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.checkOpen(() -> this.proxy.remove(key, value));
    }

    @Override
    public CompletableFuture<Void> putAll(Map<? extends K, ? extends Collection<V>> m) {
        return this.checkOpen(() -> this.proxy.putAll(m));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.checkOpen(this.proxy::clear);
    }

    @Override
    public CompletableFuture<Set<K>> keySet() {
        return this.checkOpen(this.proxy::keySet);
    }

    @Override
    public CompletableFuture<Collection<V>> values() {
        return this.checkOpen(this.proxy::values);
    }

    @Override
    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet() {
        return this.checkOpen(this.proxy::entrySet);
    }

    @Override
    public CompletableFuture<Collection<V>> getOrDefault(K key, Collection<V> defaultValue) {
        return this.checkOpen(() -> this.proxy.getOrDefault(key, defaultValue));
    }

    @Override
    public CompletableFuture<Void> replaceAll(BiFunction<? super K, ? super Collection<V>, ? extends Collection<V>> function) {
        return this.checkOpen(() -> this.proxy.replaceAll(function));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.checkOpen(() -> this.proxy.replace(key, oldValue, newValue));
    }

    @Override
    public CompletableFuture<Collection<V>> replace(K key, Collection<V> value) {
        return this.checkOpen(() -> this.proxy.replace(key, value));
    }

    public synchronized CompletableFuture<AsyncMultiMap<K, V>> open() {
        return ((CompletableFuture)((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.stateMachine.open())).thenRun(() -> {
            this.proxy = (AsyncMultiMapProxy)this.stateMachine.createProxy(AsyncMultiMapProxy.class);
        })).thenApply(v -> this);
    }

    public synchronized CompletableFuture<Void> close() {
        this.proxy = null;
        return this.stateMachine.close().thenCompose(v -> this.runShutdownTasks());
    }
}

