/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.atomic.internal;

import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.atomic.AsyncReference;
import net.kuujo.copycat.atomic.AsyncReferenceProxy;
import net.kuujo.copycat.atomic.internal.DefaultReferenceState;
import net.kuujo.copycat.atomic.internal.ReferenceState;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceManager;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.internal.DefaultStateMachine;

public class DefaultAsyncReference<T>
extends AbstractResource<AsyncReference<T>>
implements AsyncReference<T> {
    private StateMachine<ReferenceState<T>> stateMachine;
    private AsyncReferenceProxy<T> proxy;

    public DefaultAsyncReference(ResourceManager context) {
        super(context);
        this.stateMachine = new DefaultStateMachine(context, ReferenceState.class, DefaultReferenceState.class);
    }

    @Override
    public CompletableFuture<T> get() {
        return this.proxy.get();
    }

    @Override
    public CompletableFuture<Void> set(T value) {
        return this.proxy.set(value);
    }

    @Override
    public CompletableFuture<T> getAndSet(T value) {
        return this.proxy.getAndSet(value);
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(T expect, T update) {
        return this.proxy.compareAndSet(expect, update);
    }

    public synchronized CompletableFuture<AsyncReference<T>> open() {
        return ((CompletableFuture)((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.stateMachine.open())).thenRun(() -> {
            this.proxy = (AsyncReferenceProxy)this.stateMachine.createProxy(AsyncReferenceProxy.class);
        })).thenApply(v -> this);
    }

    public synchronized CompletableFuture<Void> close() {
        this.proxy = null;
        return this.stateMachine.close().thenCompose(v -> this.runShutdownTasks());
    }
}

