/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections.internal.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kuujo.copycat.collections.AsyncMap;
import net.kuujo.copycat.collections.AsyncMapProxy;
import net.kuujo.copycat.collections.internal.map.DefaultMapState;
import net.kuujo.copycat.collections.internal.map.MapState;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceManager;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.internal.DefaultStateMachine;
import net.kuujo.copycat.util.concurrent.Futures;

public class DefaultAsyncMap<K, V>
extends AbstractResource<AsyncMap<K, V>>
implements AsyncMap<K, V> {
    private final StateMachine<MapState<K, V>> stateMachine;
    private AsyncMapProxy<K, V> proxy;

    public DefaultAsyncMap(ResourceManager context) {
        super(context);
        this.stateMachine = new DefaultStateMachine(context, MapState.class, DefaultMapState.class);
    }

    protected <T> CompletableFuture<T> checkOpen(Supplier<CompletableFuture<T>> supplier) {
        if (this.proxy == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Map closed"));
        }
        return supplier.get();
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.checkOpen(this.proxy::size);
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.checkOpen(this.proxy::isEmpty);
    }

    @Override
    public CompletableFuture<Boolean> containsKey(Object key) {
        return this.checkOpen(() -> this.proxy.containsKey(key));
    }

    @Override
    public CompletableFuture<Boolean> containsValue(Object value) {
        return this.checkOpen(() -> this.proxy.containsValue(value));
    }

    @Override
    public CompletableFuture<V> get(Object key) {
        return this.checkOpen(() -> this.proxy.get(key));
    }

    @Override
    public CompletableFuture<V> put(K key, V value) {
        return this.checkOpen(() -> this.proxy.put(key, value));
    }

    @Override
    public CompletableFuture<V> remove(Object key) {
        return this.checkOpen(() -> this.proxy.remove(key));
    }

    @Override
    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> m) {
        return this.checkOpen(() -> this.proxy.putAll(m));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.checkOpen(this.proxy::clear);
    }

    @Override
    public CompletableFuture<Set<K>> keySet() {
        return this.checkOpen(this.proxy::keySet);
    }

    @Override
    public CompletableFuture<Collection<V>> values() {
        return this.checkOpen(this.proxy::values);
    }

    @Override
    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet() {
        return this.checkOpen(this.proxy::entrySet);
    }

    @Override
    public CompletableFuture<V> getOrDefault(Object key, V defaultValue) {
        return this.checkOpen(() -> this.proxy.getOrDefault(key, defaultValue));
    }

    @Override
    public CompletableFuture<Void> replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        return this.checkOpen(() -> this.proxy.replaceAll(function));
    }

    @Override
    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.checkOpen(() -> this.proxy.putIfAbsent(key, value));
    }

    @Override
    public CompletableFuture<Boolean> remove(Object key, Object value) {
        return this.checkOpen(() -> this.proxy.remove(key, value));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.checkOpen(() -> this.proxy.replace(key, oldValue, newValue));
    }

    @Override
    public CompletableFuture<V> replace(K key, V value) {
        return this.checkOpen(() -> this.proxy.replace(key, value));
    }

    @Override
    public CompletableFuture<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.checkOpen(() -> this.proxy.computeIfAbsent(key, mappingFunction));
    }

    @Override
    public CompletableFuture<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.checkOpen(() -> this.proxy.computeIfPresent(key, remappingFunction));
    }

    @Override
    public CompletableFuture<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.checkOpen(() -> this.proxy.compute(key, remappingFunction));
    }

    @Override
    public CompletableFuture<V> merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.checkOpen(() -> this.proxy.merge(key, value, remappingFunction));
    }

    public synchronized CompletableFuture<AsyncMap<K, V>> open() {
        return ((CompletableFuture)((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.stateMachine.open())).thenRun(() -> {
            this.proxy = (AsyncMapProxy)this.stateMachine.createProxy(AsyncMapProxy.class);
        })).thenApply(v -> null);
    }

    public synchronized CompletableFuture<Void> close() {
        this.proxy = null;
        return this.stateMachine.close().thenCompose(v -> this.runShutdownTasks());
    }
}

