/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.election;

import java.util.Collection;
import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.election.internal.DefaultLeaderElection;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.util.internal.Assert;

public class LeaderElectionConfig
extends ResourceConfig<LeaderElectionConfig> {
    private static final String CONFIGURATION = "election";
    private static final String DEFAULT_CONFIGURATION = "election-defaults";

    public LeaderElectionConfig() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public LeaderElectionConfig(Map<String, Object> config) {
        super(config, new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public LeaderElectionConfig(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    private LeaderElectionConfig(LeaderElectionConfig config) {
        super((ResourceConfig)config);
    }

    public LeaderElectionConfig copy() {
        return new LeaderElectionConfig(this);
    }

    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config((Object)this.getReplicas(), (this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()) ? 1 : 0) != 0, (String)"Resource replica set must contain only active cluster members", (Object[])new Object[0]);
        return new CoordinatedResourceConfig(super.toMap()).withElectionTimeout(this.getElectionTimeout()).withHeartbeatInterval(this.getHeartbeatInterval()).withExecutor(this.getExecutor()).withResourceType(DefaultLeaderElection.class).withLog(this.getLog()).withResourceConfig((ResourceConfig)this).withReplicas((Collection)(this.getReplicas().isEmpty() ? cluster.getMembers() : this.getReplicas()));
    }
}

