/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.election.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.EventListener;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.election.ElectionEvent;
import net.kuujo.copycat.election.LeaderElection;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceContext;

public class DefaultLeaderElection
extends AbstractResource<LeaderElection>
implements LeaderElection {
    private final Map<EventListener<Member>, EventListener<ElectionEvent>> listeners = new HashMap<EventListener<Member>, EventListener<ElectionEvent>>();

    public DefaultLeaderElection(ResourceContext context) {
        super(context);
    }

    @Override
    public synchronized LeaderElection addListener(EventListener<Member> listener) {
        if (!this.listeners.containsKey(listener)) {
            EventListener wrapper = event -> listener.accept((Object)event.winner());
            this.listeners.put(listener, (EventListener<ElectionEvent>)wrapper);
            this.context.cluster().election().addListener(wrapper);
        }
        return this;
    }

    @Override
    public synchronized LeaderElection removeListener(EventListener<Member> listener) {
        EventListener<ElectionEvent> wrapper = this.listeners.remove(listener);
        if (wrapper != null) {
            this.context.cluster().election().removeListener(wrapper);
        }
        return this;
    }

    public synchronized CompletableFuture<LeaderElection> open() {
        return ((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.context.open())).thenApply(v -> this);
    }

    public synchronized CompletableFuture<Void> close() {
        return this.context.close().thenCompose(v -> this.runShutdownTasks());
    }
}

