/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.state.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.kuujo.copycat.log.LogConfig;
import net.kuujo.copycat.log.LogManager;
import net.kuujo.copycat.log.LogSegment;
import net.kuujo.copycat.util.internal.Assert;

public class SnapshottableLogManager
implements LogManager {
    private final LogManager logManager;
    private final LogManager snapshotManager;

    public SnapshottableLogManager(LogManager logManager, LogManager snapshotManager) {
        this.logManager = logManager;
        this.snapshotManager = snapshotManager;
    }

    public LogConfig config() {
        return this.logManager.config();
    }

    public TreeMap<Long, LogSegment> segments() {
        return this.logManager.segments();
    }

    public LogSegment segment() {
        return this.logManager.segment();
    }

    public LogSegment segment(long index) {
        return this.snapshotManager.lastIndex() == null || index > this.snapshotManager.lastIndex() ? this.logManager.segment(index) : this.snapshotManager.segment(index);
    }

    public LogSegment firstSegment() {
        return this.snapshotManager.isEmpty() ? this.logManager.firstSegment() : this.snapshotManager.firstSegment();
    }

    public LogSegment lastSegment() {
        return this.logManager.lastSegment();
    }

    public void open() throws IOException {
        this.snapshotManager.open();
        this.logManager.open();
    }

    public boolean isEmpty() {
        return this.snapshotManager.isEmpty() && this.logManager.isEmpty();
    }

    public boolean isOpen() {
        return this.snapshotManager.isOpen() && this.logManager.isOpen();
    }

    public long size() {
        return this.snapshotManager.size() + this.logManager.size();
    }

    public long entryCount() {
        return this.snapshotManager.entryCount() + this.logManager.entryCount();
    }

    public boolean isSnapshottable(long index) {
        LogSegment segment = this.logManager.segment(index);
        if (segment == null) {
            return false;
        }
        if (segment.lastIndex() == null || segment.lastIndex() != index) {
            return false;
        }
        return segment != this.logManager.lastSegment();
    }

    public long appendSnapshot(long index, List<ByteBuffer> snapshot) throws IOException {
        LogSegment segment = this.logManager.segment(index);
        if (segment == null) {
            throw new IndexOutOfBoundsException("Invalid snapshot index " + index);
        }
        if (segment.lastIndex() != index) {
            throw new IllegalArgumentException("Snapshot index must be the last index of a segment");
        }
        if (segment == this.logManager.lastSegment()) {
            throw new IllegalArgumentException("Cannot snapshot current log segment");
        }
        this.snapshotManager.rollOver(index - (long)snapshot.size() + 1L);
        for (ByteBuffer entry : snapshot) {
            this.snapshotManager.appendEntry(entry);
        }
        this.compact(this.snapshotManager);
        this.compact(this.logManager);
        return index;
    }

    private void compact(LogManager log) {
        Iterator iterator = log.segments().entrySet().iterator();
        while (iterator.hasNext()) {
            LogSegment segment = (LogSegment)iterator.next().getValue();
            if (log.lastSegment() == segment) continue;
            iterator.remove();
            try {
                segment.close();
                segment.delete();
            }
            catch (IOException e) {}
        }
    }

    public long appendEntry(ByteBuffer entry) throws IOException {
        return this.logManager.appendEntry(entry);
    }

    public Long firstIndex() {
        return !this.snapshotManager.isEmpty() ? this.snapshotManager.firstIndex() : this.logManager.firstIndex();
    }

    public Long lastIndex() {
        return this.logManager.lastIndex();
    }

    public boolean containsIndex(long index) {
        Assert.state((boolean)this.isOpen(), (String)"Log is not open", (Object[])new Object[0]);
        return this.logManager.containsIndex(index) || this.snapshotManager.containsIndex(index);
    }

    public ByteBuffer getEntry(long index) {
        Assert.state((boolean)this.isOpen(), (String)"Log is not open", (Object[])new Object[0]);
        if (this.logManager.containsIndex(index)) {
            return this.logManager.getEntry(index);
        }
        if (this.snapshotManager.containsIndex(index)) {
            return this.snapshotManager.getEntry(index);
        }
        throw new IndexOutOfBoundsException("No entry at index " + index);
    }

    public void removeAfter(long index) {
        Assert.state((boolean)this.isOpen(), (String)"Log is not open", (Object[])new Object[0]);
        Assert.index((Number)index, (boolean)this.logManager.containsIndex(index), (String)"Log index out of bounds", (Object[])new Object[0]);
        this.logManager.removeAfter(index);
    }

    public void rollOver(long index) throws IOException {
        this.logManager.rollOver(index);
    }

    public void compact(long index) throws IOException {
        this.logManager.compact(index);
        this.snapshotManager.compact(index);
    }

    public void flush() {
        this.logManager.flush();
    }

    public void close() throws IOException {
        this.logManager.close();
        this.snapshotManager.close();
    }

    public boolean isClosed() {
        return this.logManager.isClosed();
    }

    public void delete() {
        this.logManager.delete();
        this.snapshotManager.delete();
    }
}

