/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.state;

import com.typesafe.config.ConfigValueFactory;
import java.util.Collection;
import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.state.internal.DefaultStateLog;
import net.kuujo.copycat.state.internal.SnapshottableLog;
import net.kuujo.copycat.util.internal.Assert;

public class StateLogConfig
extends ResourceConfig<StateLogConfig> {
    private static final String STATE_LOG_CONSISTENCY = "consistency";
    private static final String DEFAULT_CONFIGURATION = "event-log-defaults";
    private static final String CONFIGURATION = "event-log";

    public StateLogConfig() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public StateLogConfig(Map<String, Object> config) {
        super(config, new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public StateLogConfig(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    protected StateLogConfig(String ... resources) {
        super(StateLogConfig.addResources((String[])resources, (String[])new String[]{CONFIGURATION, DEFAULT_CONFIGURATION}));
    }

    protected StateLogConfig(Map<String, Object> config, String ... resources) {
        super(config, StateLogConfig.addResources((String[])resources, (String[])new String[]{CONFIGURATION, DEFAULT_CONFIGURATION}));
    }

    protected StateLogConfig(StateLogConfig config) {
        super((ResourceConfig)config);
    }

    public StateLogConfig copy() {
        return new StateLogConfig(this);
    }

    public void setDefaultConsistency(String consistency) {
        this.config = this.config.withValue(STATE_LOG_CONSISTENCY, ConfigValueFactory.fromAnyRef((Object)Consistency.parse((String)((String)Assert.isNotNull((Object)consistency, (String)STATE_LOG_CONSISTENCY))).toString()));
    }

    public void setDefaultConsistency(Consistency consistency) {
        this.config = this.config.withValue(STATE_LOG_CONSISTENCY, ConfigValueFactory.fromAnyRef((Object)((Consistency)Assert.isNotNull((Object)consistency, (String)STATE_LOG_CONSISTENCY)).toString()));
    }

    public Consistency getDefaultConsistency() {
        return Consistency.parse((String)this.config.getString(STATE_LOG_CONSISTENCY));
    }

    public StateLogConfig withDefaultConsistency(String consistency) {
        this.setDefaultConsistency(consistency);
        return this;
    }

    public StateLogConfig withDefaultConsistency(Consistency consistency) {
        this.setDefaultConsistency(consistency);
        return this;
    }

    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config((Object)this.getReplicas(), (this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()) ? 1 : 0) != 0, (String)"Resource replica set must contain only active cluster members", (Object[])new Object[0]);
        return new CoordinatedResourceConfig(super.toMap()).withElectionTimeout(this.getElectionTimeout()).withHeartbeatInterval(this.getHeartbeatInterval()).withResourceType(DefaultStateLog.class).withLog((Log)new SnapshottableLog(this.getLog())).withSerializer(this.getSerializer()).withExecutor(this.getExecutor()).withResourceConfig((ResourceConfig)this).withReplicas((Collection)(this.getReplicas().isEmpty() ? cluster.getMembers() : this.getReplicas()));
    }
}

