/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.state;

import com.typesafe.config.ConfigValueFactory;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.state.StateLogConfig;
import net.kuujo.copycat.state.internal.DefaultStateMachine;
import net.kuujo.copycat.util.ConfigurationException;
import net.kuujo.copycat.util.internal.Assert;
import net.kuujo.copycat.util.serializer.Serializer;

public class StateMachineConfig
extends StateLogConfig {
    private static final String STATE_MACHINE_STATE_TYPE = "state-type";
    private static final String STATE_MACHINE_INITIAL_STATE = "initial-state";
    private static final String DEFAULT_CONFIGURATION = "state-machine-defaults";
    private static final String CONFIGURATION = "state-machine";

    public StateMachineConfig() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public StateMachineConfig(Map<String, Object> config) {
        super(config, new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public StateMachineConfig(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    protected StateMachineConfig(StateMachineConfig config) {
        super((StateLogConfig)config);
    }

    public StateMachineConfig copy() {
        return new StateMachineConfig(this);
    }

    public void setStateType(String stateType) {
        try {
            this.setStateType(Class.forName((String)Assert.isNotNull((Object)stateType, (String)"stateType")));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to load state type", new Object[]{e});
        }
    }

    public void setStateType(Class<?> stateType) {
        this.config = this.config.withValue(STATE_MACHINE_STATE_TYPE, ConfigValueFactory.fromAnyRef((Object)((Class)Assert.arg(stateType, (boolean)((Class)Assert.isNotNull(stateType, (String)"stateType")).isInterface(), (String)"state type must be an interface", (Object[])new Object[0])).getName()));
    }

    public <T> Class<T> getStateType() {
        try {
            return this.config.hasPath(STATE_MACHINE_STATE_TYPE) ? Class.forName(this.config.getString(STATE_MACHINE_STATE_TYPE)) : null;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to load state type", new Object[]{e});
        }
    }

    public StateMachineConfig withStateType(String stateType) {
        this.setStateType(stateType);
        return this;
    }

    public StateMachineConfig withStateType(Class<?> stateType) {
        this.setStateType(stateType);
        return this;
    }

    public void setInitialState(String initialState) {
        try {
            this.setInitialState(Class.forName((String)Assert.isNotNull((Object)initialState, (String)"initialState")));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to load initial state", new Object[]{e});
        }
    }

    public void setInitialState(Class<?> initialState) {
        Assert.isNotNull(initialState, (String)"initialState");
        Assert.arg(initialState, (!initialState.isInterface() && !initialState.isEnum() && !initialState.isAnonymousClass() && !Modifier.isAbstract(initialState.getModifiers()) ? 1 : 0) != 0, (String)"state implementations must be concrete classes", (Object[])new Object[0]);
        this.config = this.config.withValue(STATE_MACHINE_INITIAL_STATE, ConfigValueFactory.fromAnyRef((Object)initialState.getName()));
    }

    public <T> Class<T> getInitialState() {
        try {
            return this.config.hasPath(STATE_MACHINE_INITIAL_STATE) ? Class.forName(this.config.getString(STATE_MACHINE_INITIAL_STATE)) : null;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to load initial state", new Object[]{e});
        }
    }

    public StateMachineConfig withInitialState(String initialState) {
        this.setInitialState(initialState);
        return this;
    }

    public StateMachineConfig withInitialState(Class<?> initialState) {
        this.setInitialState(initialState);
        return this;
    }

    public StateMachineConfig withSerializer(String serializer) {
        this.setSerializer(serializer);
        return this;
    }

    public StateMachineConfig withSerializer(Class<? extends Serializer> serializer) {
        this.setSerializer(serializer);
        return this;
    }

    public StateMachineConfig withSerializer(Serializer serializer) {
        this.setSerializer(serializer);
        return this;
    }

    public StateMachineConfig withExecutor(Executor executor) {
        this.setExecutor(executor);
        return this;
    }

    public StateMachineConfig withElectionTimeout(long electionTimeout) {
        this.setElectionTimeout(electionTimeout);
        return this;
    }

    public StateMachineConfig withElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(electionTimeout, unit);
        return this;
    }

    public StateMachineConfig withHeartbeatInterval(long heartbeatInterval) {
        this.setHeartbeatInterval(heartbeatInterval);
        return this;
    }

    public StateMachineConfig withHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(heartbeatInterval, unit);
        return this;
    }

    public StateMachineConfig withReplicas(String ... replicas) {
        this.setReplicas(Arrays.asList(replicas));
        return this;
    }

    public StateMachineConfig withReplicas(Collection<String> replicas) {
        this.setReplicas(replicas);
        return this;
    }

    public StateMachineConfig addReplica(String replica) {
        super.addReplica(replica);
        return this;
    }

    public StateMachineConfig removeReplica(String replica) {
        super.removeReplica(replica);
        return this;
    }

    public StateMachineConfig clearReplicas() {
        super.clearReplicas();
        return this;
    }

    public StateMachineConfig withLog(Log log) {
        this.setLog(log);
        return this;
    }

    public StateMachineConfig withDefaultConsistency(String consistency) {
        this.setDefaultConsistency(consistency);
        return this;
    }

    public StateMachineConfig withDefaultConsistency(Consistency consistency) {
        this.setDefaultConsistency(consistency);
        return this;
    }

    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config((Object)this.getReplicas(), (this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()) ? 1 : 0) != 0, (String)"Resource replica set must contain only active cluster members", (Object[])new Object[0]);
        return new StateLogConfig(this.toMap()).resolve(cluster).withResourceType(DefaultStateMachine.class).withResourceConfig((ResourceConfig)this);
    }
}

